/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.InternalRowUtils;

public class SequenceGenerator {
    private final int index;
    private final List<CoreOptions.SequenceAutoPadding> paddings;
    private final Generator generator;
    private final DataType fieldType;

    public SequenceGenerator(String field, RowType rowType) {
        this(field, rowType, Collections.emptyList());
    }

    public SequenceGenerator(String field, RowType rowType, List<CoreOptions.SequenceAutoPadding> paddings) {
        this.index = rowType.getFieldNames().indexOf(field);
        this.paddings = paddings;
        if (this.index == -1) {
            throw new RuntimeException(String.format("Can not find sequence field %s in table schema: %s", field, rowType));
        }
        this.fieldType = rowType.getTypeAt(this.index);
        this.generator = this.fieldType.accept(new SequenceGeneratorVisitor());
    }

    public SequenceGenerator(int index, DataType dataType) {
        this.index = index;
        this.paddings = Collections.emptyList();
        this.fieldType = dataType;
        if (index == -1) {
            throw new RuntimeException(String.format("Index : %s is invalid", index));
        }
        this.generator = this.fieldType.accept(new SequenceGeneratorVisitor());
    }

    @Nullable
    public static SequenceGenerator create(TableSchema schema, CoreOptions options) {
        List sequenceAutoPadding = options.sequenceAutoPadding().stream().map(CoreOptions.SequenceAutoPadding::fromString).collect(Collectors.toList());
        return options.sequenceField().map(field -> new SequenceGenerator((String)field, schema.logicalRowType(), sequenceAutoPadding)).orElse(null);
    }

    public int index() {
        return this.index;
    }

    public DataType fieldType() {
        return this.fieldType;
    }

    @Nullable
    public Long generateNullable(InternalRow row) {
        return this.generator.generateNullable(row, this.index);
    }

    public long generate(InternalRow row) {
        long sequence = this.generator.generate(row, this.index);
        block5: for (CoreOptions.SequenceAutoPadding padding : this.paddings) {
            switch (padding) {
                case ROW_KIND_FLAG: {
                    sequence = this.addRowKindFlag(sequence, row.getRowKind());
                    continue block5;
                }
                case SECOND_TO_MICRO: {
                    sequence = this.secondToMicro(sequence);
                    continue block5;
                }
                case MILLIS_TO_MICRO: {
                    sequence = this.millisToMicro(sequence);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown sequence padding mode " + padding);
        }
        return sequence;
    }

    private long addRowKindFlag(long sequence, RowKind rowKind) {
        return sequence << 1 | (long)(rowKind.isAdd() ? 1 : 0);
    }

    private long millisToMicro(long sequence) {
        return sequence * 1000L + SequenceGenerator.getCurrentMicroOfMillis();
    }

    private long secondToMicro(long sequence) {
        long second = this.fieldType.is(DataTypeFamily.TIMESTAMP) ? sequence / 1000L : sequence;
        return second * 1000000L + SequenceGenerator.getCurrentMicroOfSeconds();
    }

    private static long getCurrentMicroOfMillis() {
        long currentNanoTime = System.nanoTime();
        long mills = TimeUnit.MILLISECONDS.convert(currentNanoTime, TimeUnit.NANOSECONDS);
        return (currentNanoTime - mills * 1000000L) / 1000L;
    }

    private static long getCurrentMicroOfSeconds() {
        long currentNanoTime = System.nanoTime();
        long seconds = TimeUnit.SECONDS.convert(currentNanoTime, TimeUnit.NANOSECONDS);
        return (currentNanoTime - seconds * 1000000000L) / 1000L;
    }

    private static class SequenceGeneratorVisitor
    extends DataTypeDefaultVisitor<Generator> {
        private SequenceGeneratorVisitor() {
        }

        @Override
        public Generator visit(CharType charType) {
            return this.stringGenerator();
        }

        @Override
        public Generator visit(VarCharType varCharType) {
            return this.stringGenerator();
        }

        private Generator stringGenerator() {
            return (row, i) -> Long.parseLong(row.getString(i).toString());
        }

        @Override
        public Generator visit(DecimalType decimalType) {
            return (row, i) -> InternalRowUtils.castToIntegral(row.getDecimal(i, decimalType.getPrecision(), decimalType.getScale()));
        }

        @Override
        public Generator visit(TinyIntType tinyIntType) {
            return DataGetters::getByte;
        }

        @Override
        public Generator visit(SmallIntType smallIntType) {
            return DataGetters::getShort;
        }

        @Override
        public Generator visit(IntType intType) {
            return DataGetters::getInt;
        }

        @Override
        public Generator visit(BigIntType bigIntType) {
            return DataGetters::getLong;
        }

        @Override
        public Generator visit(FloatType floatType) {
            return (row, i) -> (long)row.getFloat(i);
        }

        @Override
        public Generator visit(DoubleType doubleType) {
            return (row, i) -> (long)row.getDouble(i);
        }

        @Override
        public Generator visit(DateType dateType) {
            return DataGetters::getInt;
        }

        @Override
        public Generator visit(TimestampType timestampType) {
            return (row, i) -> row.getTimestamp(i, timestampType.getPrecision()).getMillisecond();
        }

        @Override
        public Generator visit(LocalZonedTimestampType localZonedTimestampType) {
            return (row, i) -> row.getTimestamp(i, localZonedTimestampType.getPrecision()).getMillisecond();
        }

        @Override
        protected Generator defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported type: " + dataType);
        }
    }

    private static interface Generator {
        public long generate(InternalRow var1, int var2);

        @Nullable
        default public Long generateNullable(InternalRow row, int i) {
            if (row.isNullAt(i)) {
                return null;
            }
            return this.generate(row, i);
        }
    }
}

