/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.operation.KeyValueFileStoreRead;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.AbstractDataTableRead;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;

public abstract class KeyValueTableRead
extends AbstractDataTableRead<KeyValue> {
    protected final KeyValueFileStoreRead read;

    protected KeyValueTableRead(KeyValueFileStoreRead read, TableSchema schema) {
        super(read, schema);
        this.read = read;
    }

    @Override
    public TableRead withIOManager(IOManager ioManager) {
        this.read.withIOManager(ioManager);
        return this;
    }

    @Override
    public final RecordReader<InternalRow> reader(Split split) throws IOException {
        return new RowDataRecordReader(this.read.createReader((DataSplit)split));
    }

    public final RecordReader<KeyValue> kvReader(Split split) throws IOException {
        return this.read.createReader((DataSplit)split);
    }

    protected abstract RecordReader.RecordIterator<InternalRow> rowDataRecordIteratorFromKv(RecordReader.RecordIterator<KeyValue> var1);

    private class RowDataRecordReader
    implements RecordReader<InternalRow> {
        private final RecordReader<KeyValue> wrapped;

        private RowDataRecordReader(RecordReader<KeyValue> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        @Nullable
        public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
            RecordReader.RecordIterator<KeyValue> batch = this.wrapped.readBatch();
            return batch == null ? null : KeyValueTableRead.this.rowDataRecordIteratorFromKv(batch);
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }
    }
}

