/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.lineage.LineageMetaFactory;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.AggregationFieldsTable;
import org.apache.paimon.table.system.AllTableOptionsTable;
import org.apache.paimon.table.system.AuditLogTable;
import org.apache.paimon.table.system.CatalogOptionsTable;
import org.apache.paimon.table.system.ConsumersTable;
import org.apache.paimon.table.system.FilesTable;
import org.apache.paimon.table.system.ManifestsTable;
import org.apache.paimon.table.system.OptionsTable;
import org.apache.paimon.table.system.PartitionsTable;
import org.apache.paimon.table.system.ReadOptimizedTable;
import org.apache.paimon.table.system.SchemasTable;
import org.apache.paimon.table.system.SinkTableLineageTable;
import org.apache.paimon.table.system.SnapshotsTable;
import org.apache.paimon.table.system.SourceTableLineageTable;
import org.apache.paimon.table.system.TagsTable;
import org.apache.paimon.utils.Preconditions;

public class SystemTableLoader {
    @Nullable
    public static Table load(String type, FileIO fileIO, FileStoreTable dataTable) {
        Path location = dataTable.location();
        switch (type.toLowerCase()) {
            case "manifests": {
                return new ManifestsTable(fileIO, location, dataTable);
            }
            case "snapshots": {
                return new SnapshotsTable(fileIO, location, dataTable);
            }
            case "options": {
                return new OptionsTable(fileIO, location);
            }
            case "schemas": {
                return new SchemasTable(fileIO, location);
            }
            case "partitions": {
                return new PartitionsTable(dataTable);
            }
            case "audit_log": {
                return new AuditLogTable(dataTable);
            }
            case "files": {
                return new FilesTable(dataTable);
            }
            case "tags": {
                return new TagsTable(fileIO, location);
            }
            case "consumers": {
                return new ConsumersTable(fileIO, location);
            }
            case "ro": {
                return new ReadOptimizedTable(dataTable);
            }
            case "aggregation_fields": {
                return new AggregationFieldsTable(fileIO, location);
            }
        }
        return null;
    }

    @Nullable
    public static Table loadGlobal(String tableName, FileIO fileIO, Supplier<Map<String, Map<String, Path>>> allTablePaths, Options catalogOptions, @Nullable LineageMetaFactory lineageMetaFactory) {
        switch (tableName.toLowerCase()) {
            case "all_table_options": {
                return new AllTableOptionsTable(fileIO, allTablePaths.get());
            }
            case "catalog_options": {
                return new CatalogOptionsTable(catalogOptions);
            }
            case "source_table_lineage": {
                Preconditions.checkNotNull(lineageMetaFactory, String.format("Lineage meta should be configured for catalog with %s", CatalogOptions.LINEAGE_META.key()));
                return new SourceTableLineageTable(lineageMetaFactory, catalogOptions);
            }
            case "sink_table_lineage": {
                Preconditions.checkNotNull(lineageMetaFactory, String.format("Lineage meta should be configured for catalog with %s", CatalogOptions.LINEAGE_META.key()));
                return new SinkTableLineageTable(lineageMetaFactory, catalogOptions);
            }
        }
        return null;
    }

    public static List<String> loadGlobalTableNames() {
        return Arrays.asList("all_table_options", "catalog_options", "source_table_lineage", "sink_table_lineage");
    }
}

