/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchManager {
    private static final Logger LOG = LoggerFactory.getLogger(BranchManager.class);
    public static final String BRANCH_PREFIX = "branch-";
    private final FileIO fileIO;
    private final Path tablePath;
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final SchemaManager schemaManager;

    public BranchManager(FileIO fileIO, Path path, SnapshotManager snapshotManager, TagManager tagManager, SchemaManager schemaManager) {
        this.fileIO = fileIO;
        this.tablePath = path;
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.schemaManager = schemaManager;
    }

    public Path branchDirectory() {
        return new Path(this.tablePath + "/branch");
    }

    public static String getBranchPath(Path tablePath, String branchName) {
        return tablePath.toString() + "/branch/" + BRANCH_PREFIX + branchName;
    }

    public Path branchPath(String branchName) {
        return new Path(BranchManager.getBranchPath(this.tablePath, branchName));
    }

    public void createBranch(String branchName, String tagName) {
        Preconditions.checkArgument(!StringUtils.isBlank(branchName), "Branch name '%s' is blank.", branchName);
        Preconditions.checkArgument(!this.branchExists(branchName), "Branch name '%s' already exists.", branchName);
        Preconditions.checkArgument(this.tagManager.tagExists(tagName), "Tag name '%s' not exists.", tagName);
        Preconditions.checkArgument(!branchName.chars().allMatch(Character::isDigit), "Branch name cannot be pure numeric string but is '%s'.", branchName);
        Snapshot snapshot = this.tagManager.taggedSnapshot(tagName);
        try {
            this.fileIO.copyFileUtf8(this.tagManager.tagPath(tagName), this.tagManager.branchTagPath(branchName, tagName));
            this.fileIO.copyFileUtf8(this.snapshotManager.snapshotPath(snapshot.id()), this.snapshotManager.branchSnapshotPath(branchName, snapshot.id()));
            this.fileIO.copyFileUtf8(this.schemaManager.toSchemaPath(snapshot.schemaId()), this.schemaManager.branchSchemaPath(branchName, snapshot.schemaId()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.getBranchPath(this.tablePath, branchName)), e);
        }
    }

    public void deleteBranch(String branchName) {
        Preconditions.checkArgument(this.branchExists(branchName), "Branch name '%s' doesn't exist.", branchName);
        try {
            this.fileIO.delete(this.branchPath(branchName), true);
        }
        catch (IOException e) {
            LOG.info(String.format("Deleting the branch failed due to an exception in deleting the directory %s. Please try again.", BranchManager.getBranchPath(this.tablePath, branchName)), (Throwable)e);
        }
    }

    public boolean fileExists(Path path) {
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if path '%s' exists.", path), e);
        }
    }

    public boolean branchExists(String branchName) {
        Path branchPath = this.branchPath(branchName);
        return this.fileExists(branchPath);
    }
}

