/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.RandomAccessFile;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.BloomFilter;
import org.apache.paimon.utils.Preconditions;

public class FileBasedBloomFilter {
    private final RandomAccessFile file;
    private final CacheManager cacheManager;
    private final BloomFilter filter;
    private final long readOffset;
    private final int readLength;
    private int accessCount;

    public FileBasedBloomFilter(RandomAccessFile file, CacheManager cacheManager, long numRecords, long readOffset, int readLength) {
        this.file = file;
        this.cacheManager = cacheManager;
        Preconditions.checkArgument(numRecords >= 0L);
        this.filter = new BloomFilter(numRecords, readLength);
        this.readOffset = readOffset;
        this.readLength = readLength;
        this.accessCount = 0;
    }

    public boolean testHash(int hash) {
        ++this.accessCount;
        if (this.accessCount == 10 || this.filter.getMemorySegment() == null) {
            MemorySegment segment = this.cacheManager.getPage(this.file, this.readOffset, this.readLength, (position, length) -> this.filter.unsetMemorySegment());
            this.filter.setMemorySegment(segment, 0);
            this.accessCount = 0;
        }
        return this.filter.testHash(hash);
    }

    @VisibleForTesting
    BloomFilter bloomFilter() {
        return this.filter;
    }
}

