/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Arrays;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;

public class KeyProjectedRow
implements InternalRow {
    private final int[] indexMapping;
    private InternalRow row;

    public KeyProjectedRow(int[] indexMapping) {
        this.indexMapping = indexMapping;
    }

    public KeyProjectedRow replaceRow(InternalRow row) {
        this.row = row;
        return this;
    }

    @Override
    public int getFieldCount() {
        return this.indexMapping.length;
    }

    @Override
    public RowKind getRowKind() {
        return RowKind.INSERT;
    }

    @Override
    public void setRowKind(RowKind kind) {
        throw new UnsupportedOperationException("Key row data should always be insert only.");
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(this.indexMapping[pos]);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.indexMapping[pos]);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(this.indexMapping[pos]);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(this.indexMapping[pos]);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(this.indexMapping[pos]);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(this.indexMapping[pos]);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(this.indexMapping[pos]);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(this.indexMapping[pos]);
    }

    @Override
    public BinaryString getString(int pos) {
        return this.row.getString(this.indexMapping[pos]);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.indexMapping[pos], precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.indexMapping[pos], precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.indexMapping[pos]);
    }

    @Override
    public InternalArray getArray(int pos) {
        return this.row.getArray(this.indexMapping[pos]);
    }

    @Override
    public InternalMap getMap(int pos) {
        return this.row.getMap(this.indexMapping[pos]);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return this.row.getRow(this.indexMapping[pos], numFields);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Projected row data cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Projected row data cannot be hashed");
    }

    public String toString() {
        return this.getRowKind().shortString() + "{indexMapping=" + Arrays.toString(this.indexMapping) + ", mutableRow=" + this.row + '}';
    }
}

