/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

public class MathUtils {
    public static int roundDownToPowerOf2(int value) {
        return Integer.highestOneBit(value);
    }

    public static boolean isPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }

    public static int log2strict(int value) throws ArithmeticException, IllegalArgumentException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException("The given value " + value + " is not a power of two.");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static Integer max(Integer v1, Integer v2) {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 != null && v2 == null) {
            return v1;
        }
        if (v1 == null) {
            return v2;
        }
        return Math.max(v1, v2);
    }

    public static Integer min(Integer v1, Integer v2) {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 != null && v2 == null) {
            return v1;
        }
        if (v1 == null) {
            return v2;
        }
        return Math.min(v1, v2);
    }
}

