/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.RollbackToAction;

public class RollbackToActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "rollback_to";
    private static final String VERSION = "version";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        this.checkRequiredArgument(params, VERSION);
        String version = params.get(VERSION);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        RollbackToAction action = new RollbackToAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, version, catalogConfig);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"rollback_to\" roll back a table to a specific snapshot ID or tag.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  rollback_to --warehouse <warehouse_path> --database <database_name> --table <table_name> --version <version_string>");
        System.out.println("  <version_string> can be a long value representing a snapshot ID or a tag name.");
        System.out.println();
    }
}

