/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.sink.FlinkSinkBuilder;
import org.apache.paimon.table.Table;

public abstract class TableActionBase
extends ActionBase {
    protected Table table;
    protected final Identifier identifier;

    TableActionBase(String warehouse, String databaseName, String tableName, Map<String, String> catalogConfig) {
        super(warehouse, catalogConfig);
        this.identifier = new Identifier(databaseName, tableName);
        try {
            this.table = this.catalog.getTable(this.identifier);
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    public TableResult batchSink(DataStream<RowData> dataStream) {
        List<Transformation<?>> transformations = Collections.singletonList(new FlinkSinkBuilder(this.table).forRowData(dataStream).build().getTransformation());
        List<String> sinkIdentifierNames = Collections.singletonList(this.identifier.getFullName());
        return this.executeInternal(transformations, sinkIdentifierNames);
    }

    private TableResult executeInternal(List<Transformation<?>> transformations, List<String> sinkIdentifierNames) {
        Class<?> clazz = this.batchTEnv.getClass().getSuperclass().getSuperclass();
        try {
            Method executeInternal = clazz.getDeclaredMethod("executeInternal", List.class, List.class);
            executeInternal.setAccessible(true);
            return (TableResult)executeInternal.invoke((Object)this.batchTEnv, transformations, sinkIdentifierNames);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to get 'TableEnvironmentImpl#executeInternal(List, List)' method from given StreamTableEnvironment instance by Java reflection. This is unexpected.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke 'TableEnvironmentImpl#executeInternal(List, List)' method from given StreamTableEnvironment instance by Java reflection. This is unexpected.", e);
        }
    }
}

