/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.CompactAction;
import org.apache.paimon.flink.action.SortCompactAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;

public class CompactProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "compact";

    public String[] call(ProcedureContext procedureContext, String tableId) throws Exception {
        return this.call(procedureContext, tableId, "");
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String partitions) throws Exception {
        return this.call(procedureContext, tableId, partitions, "", "", "");
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String partitions, String orderStrategy, String orderByColumns) throws Exception {
        return this.call(procedureContext, tableId, partitions, orderStrategy, orderByColumns, "");
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String partitions, String orderStrategy, String orderByColumns, String tableOptions) throws Exception {
        String jobName;
        CompactAction action;
        String warehouse = this.catalog.warehouse();
        Map<String, String> catalogOptions = this.catalog.options();
        Map<String, String> tableConf = StringUtils.isBlank(tableOptions) ? Collections.emptyMap() : ParameterUtils.parseCommaSeparatedKeyValues(tableOptions);
        Identifier identifier = Identifier.fromString(tableId);
        if (orderStrategy.isEmpty() && orderByColumns.isEmpty()) {
            action = new CompactAction(warehouse, identifier.getDatabaseName(), identifier.getObjectName(), catalogOptions, tableConf);
            jobName = "Compact Job";
        } else if (!orderStrategy.isEmpty() && !orderByColumns.isEmpty()) {
            action = new SortCompactAction(warehouse, identifier.getDatabaseName(), identifier.getObjectName(), catalogOptions, tableConf).withOrderStrategy(orderStrategy).withOrderColumns(orderByColumns.split(","));
            jobName = "Sort Compact Job";
        } else {
            throw new IllegalArgumentException("You must specify 'order strategy' and 'order by columns' both.");
        }
        if (!StringUtils.isBlank(partitions)) {
            action.withPartitions(ParameterUtils.getPartitions(partitions.split(";")));
        }
        return this.execute(procedureContext, action, jobName);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

