/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Objects;
import org.apache.paimon.consumer.Consumer;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.table.FileStoreTable;

public class ResetConsumerAction
extends TableActionBase {
    private final String consumerId;
    private Long nextSnapshotId;

    protected ResetConsumerAction(String warehouse, String databaseName, String tableName, Map<String, String> catalogConfig, String consumerId) {
        super(warehouse, databaseName, tableName, catalogConfig);
        this.consumerId = consumerId;
    }

    public ResetConsumerAction withNextSnapshotIds(Long nextSnapshotId) {
        this.nextSnapshotId = nextSnapshotId;
        return this;
    }

    @Override
    public void run() throws Exception {
        FileStoreTable dataTable = (FileStoreTable)this.table;
        ConsumerManager consumerManager = new ConsumerManager(dataTable.fileIO(), dataTable.location(), dataTable.snapshotManager().branch());
        if (Objects.isNull(this.nextSnapshotId)) {
            consumerManager.deleteConsumer(this.consumerId);
        } else {
            consumerManager.resetConsumer(this.consumerId, new Consumer(this.nextSnapshotId));
        }
    }
}

