/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Map;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.action.CompactDatabaseAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TimeUtils;

public class CompactDatabaseProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "compact_database";

    public String[] call(ProcedureContext procedureContext) throws Exception {
        return this.call(procedureContext, "");
    }

    public String[] call(ProcedureContext procedureContext, String includingDatabases) throws Exception {
        return this.call(procedureContext, includingDatabases, "");
    }

    public String[] call(ProcedureContext procedureContext, String includingDatabases, String mode) throws Exception {
        return this.call(procedureContext, includingDatabases, mode, "");
    }

    public String[] call(ProcedureContext procedureContext, String includingDatabases, String mode, String includingTables) throws Exception {
        return this.call(procedureContext, includingDatabases, mode, includingTables, "");
    }

    public String[] call(ProcedureContext procedureContext, String includingDatabases, String mode, String includingTables, String excludingTables) throws Exception {
        return this.call(procedureContext, includingDatabases, mode, includingTables, excludingTables, "");
    }

    public String[] call(ProcedureContext procedureContext, String includingDatabases, String mode, String includingTables, String excludingTables, String tableOptions) throws Exception {
        return this.call(procedureContext, includingDatabases, mode, includingTables, excludingTables, tableOptions, "");
    }

    public String[] call(ProcedureContext procedureContext, String includingDatabases, String mode, String includingTables, String excludingTables, String tableOptions, String partitionIdleTime) throws Exception {
        String warehouse = this.catalog.warehouse();
        Map<String, String> catalogOptions = this.catalog.options();
        CompactDatabaseAction action = new CompactDatabaseAction(warehouse, catalogOptions).includingDatabases(this.nullable(includingDatabases)).includingTables(this.nullable(includingTables)).excludingTables(this.nullable(excludingTables)).withDatabaseCompactMode(this.nullable(mode));
        if (!StringUtils.isBlank(tableOptions)) {
            action.withTableOptions(ParameterUtils.parseCommaSeparatedKeyValues(tableOptions));
        }
        if (!StringUtils.isBlank(partitionIdleTime)) {
            action.withPartitionIdleTime(TimeUtils.parseDuration(partitionIdleTime));
        }
        return this.execute(procedureContext, action, "Compact database job");
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

