/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.utils.ParameterUtils;

public class MigrateDatabaseProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "migrate_database";
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceDatabasePath) throws Exception {
        return this.call(procedureContext, connector, sourceDatabasePath, "");
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceDatabasePath, String properties) throws Exception {
        List<Migrator> migrators = TableMigrationUtils.getImporters(connector, this.catalog, sourceDatabasePath, ParameterUtils.parseCommaSeparatedKeyValues(properties));
        for (Migrator migrator : migrators) {
            migrator.executeMigrate();
            migrator.renameTable(false);
        }
        return new String[]{"Success"};
    }
}

