/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.utils.StringUtils;

public class RemoveOrphanFilesProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "remove_orphan_files";

    public String[] call(ProcedureContext procedureContext, String tableId) throws Exception {
        return this.call(procedureContext, tableId, "");
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan) throws Exception {
        return this.call(procedureContext, tableId, olderThan, false);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan, boolean dryRun) throws Exception {
        Identifier identifier = Identifier.fromString(tableId);
        String databaseName = identifier.getDatabaseName();
        String tableName = identifier.getObjectName();
        List<OrphanFilesClean> tableCleans = OrphanFilesClean.createOrphanFilesCleans(this.catalog, databaseName, tableName);
        if (!StringUtils.isBlank(olderThan)) {
            tableCleans.forEach(clean -> clean.olderThan(olderThan));
        }
        if (dryRun) {
            tableCleans.forEach(clean -> clean.fileCleaner(path -> {}));
        }
        return OrphanFilesClean.executeOrphanFilesClean(tableCleans);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

