/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.PredicateReplaceVisitor;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.primitives.Ints;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingContext;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class AuditLogTable
implements DataTable,
ReadonlyTable {
    public static final String AUDIT_LOG = "audit_log";
    public static final String ROW_KIND = "rowkind";
    public static final PredicateReplaceVisitor PREDICATE_CONVERTER = p -> {
        if (p.index() == 0) {
            return Optional.empty();
        }
        return Optional.of(new LeafPredicate(p.function(), p.type(), p.index() - 1, p.fieldName(), p.literals()));
    };
    private final FileStoreTable wrapped;

    public AuditLogTable(FileStoreTable wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public OptionalLong latestSnapshotId() {
        return this.wrapped.latestSnapshotId();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public String name() {
        return this.wrapped.name() + "$" + AUDIT_LOG;
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, ROW_KIND, new VarCharType(Integer.MAX_VALUE)));
        fields.addAll(this.wrapped.rowType().getFields());
        return new RowType(fields);
    }

    @Override
    public List<String> partitionKeys() {
        return this.wrapped.partitionKeys();
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return new AuditLogDataReader(this.wrapped.newSnapshotReader());
    }

    @Override
    public DataTableScan newScan() {
        return new AuditLogBatchScan(this.wrapped.newScan());
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        return new AuditLogStreamScan(this.wrapped.newStreamScan());
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new AuditLogTable(this.wrapped.switchToBranch(branchName));
    }

    @Override
    public InnerTableRead newRead() {
        return new AuditLogRead(this.wrapped.newRead());
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new AuditLogTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }

    private Optional<Predicate> convert(Predicate predicate) {
        List<Predicate> result = PredicateBuilder.splitAnd(predicate).stream().map(p -> p.visit(PREDICATE_CONVERTER)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PredicateBuilder.and(result));
    }

    private static class AuditLogRow
    extends ProjectedRow {
        private AuditLogRow(int[] indexMapping, InternalRow row) {
            super(indexMapping);
            this.replaceRow(row);
        }

        @Override
        public RowKind getRowKind() {
            return RowKind.INSERT;
        }

        @Override
        public void setRowKind(RowKind kind) {
            throw new UnsupportedOperationException("Set row kind is not supported in AuditLogRowData.");
        }

        @Override
        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return super.isNullAt(pos);
        }

        @Override
        public BinaryString getString(int pos) {
            if (this.indexMapping[pos] < 0) {
                return BinaryString.fromString(this.row.getRowKind().shortString());
            }
            return super.getString(pos);
        }
    }

    private class AuditLogRead
    implements InnerTableRead {
        private final InnerTableRead dataRead;
        private int[] readProjection;

        private AuditLogRead(InnerTableRead dataRead) {
            this.dataRead = dataRead.forceKeepDelete();
            this.readProjection = this.defaultProjection();
        }

        private int[] defaultProjection() {
            int dataFieldCount = AuditLogTable.this.wrapped.rowType().getFieldCount();
            int[] projection = new int[dataFieldCount + 1];
            projection[0] = -1;
            for (int i = 0; i < dataFieldCount; ++i) {
                projection[i + 1] = i;
            }
            return projection;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.dataRead::withFilter);
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            ArrayList<int[]> dataProjection = new ArrayList<int[]>();
            ArrayList<Integer> readProjection = new ArrayList<Integer>();
            boolean rowKindAppeared = false;
            for (int i = 0; i < projection.length; ++i) {
                int[] field = projection[i];
                int topField = field[0];
                if (topField == 0) {
                    rowKindAppeared = true;
                    readProjection.add(-1);
                    continue;
                }
                int[] newField = Arrays.copyOf(field, field.length);
                newField[0] = newField[0] - 1;
                dataProjection.add(newField);
                readProjection.add(rowKindAppeared ? i - 1 : i);
            }
            this.readProjection = Ints.toArray(readProjection);
            this.dataRead.withProjection((int[][])dataProjection.toArray((T[])new int[0][]));
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            this.dataRead.withIOManager(ioManager);
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            return this.dataRead.createReader(split).transform(this::convertRow);
        }

        private InternalRow convertRow(InternalRow data) {
            return new AuditLogRow(this.readProjection, data);
        }
    }

    private class AuditLogStreamScan
    implements StreamDataTableScan {
        private final StreamDataTableScan streamScan;

        private AuditLogStreamScan(StreamDataTableScan streamScan) {
            this.streamScan = streamScan;
        }

        @Override
        public StreamDataTableScan withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.streamScan::withFilter);
            return this;
        }

        @Override
        public StartingContext startingContext() {
            return this.streamScan.startingContext();
        }

        @Override
        public TableScan.Plan plan() {
            return this.streamScan.plan();
        }

        @Override
        public List<PartitionEntry> listPartitionEntries() {
            return this.streamScan.listPartitionEntries();
        }

        @Override
        @Nullable
        public Long checkpoint() {
            return this.streamScan.checkpoint();
        }

        @Override
        @Nullable
        public Long watermark() {
            return this.streamScan.watermark();
        }

        @Override
        public void restore(@Nullable Long nextSnapshotId) {
            this.streamScan.restore(nextSnapshotId);
        }

        @Override
        public void restore(@Nullable Long nextSnapshotId, boolean scanAllSnapshot) {
            this.streamScan.restore(nextSnapshotId, scanAllSnapshot);
        }

        @Override
        public void notifyCheckpointComplete(@Nullable Long nextSnapshot) {
            this.streamScan.notifyCheckpointComplete(nextSnapshot);
        }

        @Override
        public StreamDataTableScan withMetricsRegistry(MetricRegistry metricsRegistry) {
            this.streamScan.withMetricsRegistry(metricsRegistry);
            return this;
        }

        @Override
        public DataTableScan withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.streamScan.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }
    }

    private class AuditLogBatchScan
    implements DataTableScan {
        private final DataTableScan batchScan;

        private AuditLogBatchScan(DataTableScan batchScan) {
            this.batchScan = batchScan;
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.batchScan::withFilter);
            return this;
        }

        @Override
        public InnerTableScan withMetricsRegistry(MetricRegistry metricsRegistry) {
            this.batchScan.withMetricsRegistry(metricsRegistry);
            return this;
        }

        @Override
        public InnerTableScan withLimit(int limit) {
            this.batchScan.withLimit(limit);
            return this;
        }

        @Override
        public InnerTableScan withPartitionFilter(Map<String, String> partitionSpec) {
            this.batchScan.withPartitionFilter(partitionSpec);
            return this;
        }

        @Override
        public InnerTableScan withPartitionFilter(List<BinaryRow> partitions) {
            this.batchScan.withPartitionFilter(partitions);
            return this;
        }

        @Override
        public InnerTableScan withBucketFilter(Filter<Integer> bucketFilter) {
            this.batchScan.withBucketFilter(bucketFilter);
            return this;
        }

        @Override
        public InnerTableScan withLevelFilter(Filter<Integer> levelFilter) {
            this.batchScan.withLevelFilter(levelFilter);
            return this;
        }

        @Override
        public TableScan.Plan plan() {
            return this.batchScan.plan();
        }

        @Override
        public List<PartitionEntry> listPartitionEntries() {
            return this.batchScan.listPartitionEntries();
        }

        @Override
        public DataTableScan withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.batchScan.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }
    }

    private class AuditLogDataReader
    implements SnapshotReader {
        private final SnapshotReader snapshotReader;

        private AuditLogDataReader(SnapshotReader snapshotReader) {
            this.snapshotReader = snapshotReader;
        }

        @Override
        public SnapshotManager snapshotManager() {
            return this.snapshotReader.snapshotManager();
        }

        @Override
        public ConsumerManager consumerManager() {
            return this.snapshotReader.consumerManager();
        }

        @Override
        public SplitGenerator splitGenerator() {
            return this.snapshotReader.splitGenerator();
        }

        @Override
        public SnapshotReader withSnapshot(long snapshotId) {
            this.snapshotReader.withSnapshot(snapshotId);
            return this;
        }

        @Override
        public SnapshotReader withSnapshot(Snapshot snapshot) {
            this.snapshotReader.withSnapshot(snapshot);
            return this;
        }

        @Override
        public SnapshotReader withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.snapshotReader::withFilter);
            return this;
        }

        @Override
        public SnapshotReader withPartitionFilter(Map<String, String> partitionSpec) {
            this.snapshotReader.withPartitionFilter(partitionSpec);
            return this;
        }

        @Override
        public SnapshotReader withPartitionFilter(Predicate predicate) {
            this.snapshotReader.withPartitionFilter(predicate);
            return this;
        }

        @Override
        public SnapshotReader withPartitionFilter(List<BinaryRow> partitions) {
            this.snapshotReader.withPartitionFilter(partitions);
            return this;
        }

        @Override
        public SnapshotReader withMode(ScanMode scanMode) {
            this.snapshotReader.withMode(scanMode);
            return this;
        }

        @Override
        public SnapshotReader withLevelFilter(Filter<Integer> levelFilter) {
            this.snapshotReader.withLevelFilter(levelFilter);
            return this;
        }

        @Override
        public SnapshotReader withManifestEntryFilter(Filter<ManifestEntry> filter) {
            this.snapshotReader.withManifestEntryFilter(filter);
            return this;
        }

        @Override
        public SnapshotReader withBucket(int bucket) {
            this.snapshotReader.withBucket(bucket);
            return this;
        }

        @Override
        public SnapshotReader withBucketFilter(Filter<Integer> bucketFilter) {
            this.snapshotReader.withBucketFilter(bucketFilter);
            return this;
        }

        @Override
        public SnapshotReader withDataFileNameFilter(Filter<String> fileNameFilter) {
            this.snapshotReader.withDataFileNameFilter(fileNameFilter);
            return this;
        }

        @Override
        public SnapshotReader withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.snapshotReader.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }

        @Override
        public SnapshotReader withMetricRegistry(MetricRegistry registry) {
            this.snapshotReader.withMetricRegistry(registry);
            return this;
        }

        @Override
        public SnapshotReader.Plan read() {
            return this.snapshotReader.read();
        }

        @Override
        public SnapshotReader.Plan readChanges() {
            return this.snapshotReader.readChanges();
        }

        @Override
        public SnapshotReader.Plan readIncrementalDiff(Snapshot before) {
            return this.snapshotReader.readIncrementalDiff(before);
        }

        @Override
        public List<BinaryRow> partitions() {
            return this.snapshotReader.partitions();
        }

        @Override
        public List<PartitionEntry> partitionEntries() {
            return this.snapshotReader.partitionEntries();
        }
    }
}

