/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.ExpireSnapshotsAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class ExpireSnapshotsActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "expire_snapshots";
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String RETAIN_MAX = "retain_max";
    private static final String RETAIN_MIN = "retain_min";
    private static final String OLDER_THAN = "older_than";
    private static final String MAX_DELETES = "max_deletes";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Integer retainMax = params.has(RETAIN_MAX) ? Integer.valueOf(Integer.parseInt(params.get(RETAIN_MAX))) : null;
        Integer retainMin = params.has(RETAIN_MIN) ? Integer.valueOf(Integer.parseInt(params.get(RETAIN_MIN))) : null;
        String olderThan = params.has(OLDER_THAN) ? params.get(OLDER_THAN) : null;
        Integer maxDeletes = params.has(MAX_DELETES) ? Integer.valueOf(Integer.parseInt(params.get(MAX_DELETES))) : null;
        ExpireSnapshotsAction action = new ExpireSnapshotsAction(params.getRequired("database"), params.getRequired("table"), this.catalogConfigMap(params), retainMax, retainMin, olderThan, maxDeletes);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"expire_snapshots\" expire the target snapshots.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  expire_snapshots --warehouse <warehouse_path> --database <database> --table <table> --retain_max <max> --retain_min <min> --older_than <older_than> --max_delete <max_delete>");
    }
}

