/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MigrateTableAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class MigrateTableActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "migrate_table";
    private static final String SOURCE_TYPE = "source_type";
    private static final String OPTIONS = "options";
    private static final String PARALLELISM = "parallelism";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String connector = params.get(SOURCE_TYPE);
        String sourceHiveTable = params.get("table");
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        String tableConf = params.get(OPTIONS);
        Integer parallelism = Integer.parseInt(params.get(PARALLELISM));
        MigrateTableAction migrateTableAction = new MigrateTableAction(connector, sourceHiveTable, catalogConfig, tableConf, parallelism);
        return Optional.of(migrateTableAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"migrate_table\" runs a migrating job from hive to paimon.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  migrate_table --warehouse <warehouse_path> --source_type hive --table <database.table_name> [--catalog_conf <key>=<value] [--options <key>=<value>,<key>=<value>,...]");
    }
}

