/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.cdc.connectors.mongodb.internal.MongoDBEnvelope;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionUtils;
import org.apache.paimon.flink.action.cdc.mongodb.SchemaAcquisitionMode;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataTypes;
import org.bson.Document;

public class MongodbSchemaUtils {
    private static final String ID_FIELD = "_id";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Schema getMongodbSchema(Configuration mongodbConfig) {
        SchemaAcquisitionMode mode = MongodbSchemaUtils.getModeFromConfig(mongodbConfig);
        String databaseName = (String)Objects.requireNonNull(mongodbConfig.get(MongoDBSourceOptions.DATABASE), "Database name cannot be null");
        String collectionName = (String)Objects.requireNonNull(mongodbConfig.get(MongoDBSourceOptions.COLLECTION), "Collection name cannot be null");
        switch (mode) {
            case SPECIFIED: {
                String[] columnNames = ((String)Objects.requireNonNull(mongodbConfig.get(MongoDBActionUtils.FIELD_NAME), "Field names cannot be null")).split(",");
                return MongodbSchemaUtils.createMongodbSchema(columnNames);
            }
            case DYNAMIC: {
                String hosts = (String)Objects.requireNonNull(mongodbConfig.get(MongoDBSourceOptions.HOSTS), "Hosts cannot be null");
                MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();
                settingsBuilder.applyConnectionString(new ConnectionString(MongodbSchemaUtils.buildConnectionString((String)mongodbConfig.get(MongoDBSourceOptions.USERNAME), (String)mongodbConfig.get(MongoDBSourceOptions.PASSWORD), (String)mongodbConfig.get(MongoDBSourceOptions.SCHEME), hosts, (String)mongodbConfig.get(MongoDBSourceOptions.CONNECTION_OPTIONS))));
                MongoClientSettings settings = settingsBuilder.build();
                try (MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);){
                    MongoDatabase database = mongoClient.getDatabase(databaseName);
                    MongoCollection collection = database.getCollection(collectionName);
                    Document firstDocument = (Document)collection.find().first();
                    if (firstDocument == null) {
                        throw new IllegalStateException("No documents in collection to infer schema");
                    }
                    Schema schema = MongodbSchemaUtils.createMongodbSchema(MongodbSchemaUtils.getColumnNames(firstDocument));
                    return schema;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create schema from MongoDB collection", e);
                }
            }
        }
        throw new IllegalArgumentException("Unsupported schema acquisition mode: " + (Object)((Object)mode));
    }

    private static String buildConnectionString(@Nullable String username, @Nullable String password, String scheme, String hosts, @Nullable String connectionOptions) {
        StringBuilder sb = new StringBuilder(scheme).append("://");
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            sb.append(MongoDBEnvelope.encodeValue((String)username)).append(":").append(MongoDBEnvelope.encodeValue((String)password)).append("@");
        }
        sb.append((String)Preconditions.checkNotNull((Object)hosts));
        if (StringUtils.isNotEmpty((CharSequence)connectionOptions)) {
            sb.append("/?").append(connectionOptions);
        }
        return sb.toString();
    }

    private static SchemaAcquisitionMode getModeFromConfig(Configuration mongodbConfig) {
        return SchemaAcquisitionMode.valueOf(((String)mongodbConfig.get(MongoDBActionUtils.START_MODE)).toUpperCase());
    }

    private static List<String> getColumnNames(Document document) {
        return document != null ? new ArrayList(document.keySet()) : Collections.emptyList();
    }

    private static Schema createMongodbSchema(String[] columnNames) {
        return MongodbSchemaUtils.createMongodbSchema(Arrays.asList(columnNames));
    }

    private static Schema createMongodbSchema(List<String> columnNames) {
        Schema.Builder builder = Schema.newBuilder();
        for (String column : columnNames) {
            builder.column(column, DataTypes.STRING());
        }
        builder.primaryKey(ID_FIELD);
        return builder.build();
    }
}

