/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb.strategy;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionUtils;
import org.apache.paimon.flink.action.cdc.mongodb.SchemaAcquisitionMode;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.JsonSerdeUtil;

public interface MongoVersionStrategy {
    public static final String ID_FIELD = "_id";
    public static final String OID_FIELD = "$oid";

    public List<RichCdcMultiplexRecord> extractRecords(JsonNode var1) throws JsonProcessingException;

    default public List<String> extractPrimaryKeys() {
        return Collections.singletonList(ID_FIELD);
    }

    default public Map<String, String> getExtractRow(JsonNode jsonNode, RowType.Builder rowTypeBuilder, List<ComputedColumn> computedColumns, Configuration mongodbConfig) throws JsonProcessingException {
        SchemaAcquisitionMode mode = SchemaAcquisitionMode.valueOf(((String)mongodbConfig.get(MongoDBActionUtils.START_MODE)).toUpperCase());
        ObjectNode objectNode = JsonSerdeUtil.asSpecificNodeType(jsonNode.asText(), ObjectNode.class);
        JsonNode idNode = objectNode.get(ID_FIELD);
        if (idNode == null) {
            throw new IllegalArgumentException("The provided MongoDB JSON document does not contain an _id field.");
        }
        ObjectNode document = (Boolean)mongodbConfig.get(MongoDBActionUtils.DEFAULT_ID_GENERATION) != false ? objectNode.set(ID_FIELD, idNode.get(OID_FIELD) == null ? idNode : idNode.get(OID_FIELD)) : objectNode;
        switch (mode) {
            case SPECIFIED: {
                return MongoVersionStrategy.parseFieldsFromJsonRecord(((JsonNode)document).toString(), (String)mongodbConfig.get(MongoDBActionUtils.PARSER_PATH), (String)mongodbConfig.get(MongoDBActionUtils.FIELD_NAME), computedColumns, rowTypeBuilder);
            }
            case DYNAMIC: {
                return this.parseAndTypeJsonRow(((JsonNode)document).toString(), rowTypeBuilder, computedColumns);
            }
        }
        throw new RuntimeException("Unsupported extraction mode: " + (Object)((Object)mode));
    }

    default public Map<String, String> parseAndTypeJsonRow(String evaluate, RowType.Builder rowTypeBuilder, List<ComputedColumn> computedColumns) {
        LinkedHashMap<String, String> parsedRow = JsonSerdeUtil.parseJsonMap(evaluate, String.class);
        return MongoVersionStrategy.processParsedData(parsedRow, rowTypeBuilder, computedColumns);
    }

    public static Map<String, String> parseFieldsFromJsonRecord(String record, String fieldPaths, String fieldNames, List<ComputedColumn> computedColumns, RowType.Builder rowTypeBuilder) {
        String[] columnNames = fieldNames.split(",");
        String[] parseNames = fieldPaths.split(",");
        HashMap<String, String> parsedRow = new HashMap<String, String>();
        for (int i = 0; i < parseNames.length; ++i) {
            String evaluate = (String)JsonPath.read((String)record, (String)parseNames[i], (Predicate[])new Predicate[0]);
            parsedRow.put(columnNames[i], Optional.ofNullable(evaluate).orElse("{}"));
        }
        return MongoVersionStrategy.processParsedData(parsedRow, rowTypeBuilder, computedColumns);
    }

    public static Map<String, String> processParsedData(Map<String, String> parsedRow, RowType.Builder rowTypeBuilder, List<ComputedColumn> computedColumns) {
        int initialCapacity = parsedRow.size() + computedColumns.size();
        HashMap<String, String> resultMap = new HashMap<String, String>(initialCapacity);
        parsedRow.forEach((column, value) -> {
            rowTypeBuilder.field((String)column, DataTypes.STRING());
            resultMap.put((String)column, (String)value);
        });
        computedColumns.forEach(computedColumn -> {
            String columnName = computedColumn.columnName();
            String fieldReference = computedColumn.fieldReference();
            String computedValue = computedColumn.eval((String)parsedRow.get(fieldReference));
            resultMap.put(columnName, computedValue);
            rowTypeBuilder.field(columnName, computedColumn.columnType());
        });
        return resultMap;
    }
}

