/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.SupplierWithIOException;

public class PickFilesUtil {
    private static final int READ_FILE_RETRY_NUM = 3;
    private static final int READ_FILE_RETRY_INTERVAL = 5;

    public static List<Path> getUsedFilesForLatestSnapshot(FileStoreTable table) {
        FileStore<?> store = table.store();
        SnapshotManager snapshotManager = store.snapshotManager();
        Snapshot snapshot = snapshotManager.latestSnapshot();
        ManifestList manifestList = store.manifestListFactory().create();
        SchemaManager schemaManager = new SchemaManager(table.fileIO(), table.location());
        IndexFileHandler indexFileHandler = store.newIndexFileHandler();
        ArrayList<Path> files = new ArrayList<Path>();
        if (snapshot != null) {
            files.add(snapshotManager.snapshotPath(snapshot.id()));
            files.addAll(PickFilesUtil.getUsedFilesInternal(snapshot, store.pathFactory(), store.newScan(), manifestList, indexFileHandler));
        }
        for (long id : schemaManager.listAllIds()) {
            files.add(schemaManager.toSchemaPath(id));
        }
        return files;
    }

    private static List<Path> getUsedFilesInternal(Snapshot snapshot, FileStorePathFactory pathFactory, FileStoreScan scan, ManifestList manifestList, IndexFileHandler indexFileHandler) {
        ArrayList<Path> files = new ArrayList<Path>();
        PickFilesUtil.addManifestList(files, snapshot, pathFactory);
        try {
            List manifestFileMetas = PickFilesUtil.retryReadingFiles(() -> PickFilesUtil.readAllManifestsWithIOException(snapshot, manifestList));
            if (manifestFileMetas == null) {
                return Collections.emptyList();
            }
            List manifestFileName = manifestFileMetas.stream().map(ManifestFileMeta::fileName).collect(Collectors.toList());
            files.addAll(manifestFileName.stream().map(pathFactory::toManifestFilePath).collect(Collectors.toList()));
            ArrayList<Path> dataFiles = new ArrayList<Path>();
            List<SimpleFileEntry> simpleFileEntries = scan.withSnapshot(snapshot).readSimpleEntries();
            for (SimpleFileEntry simpleFileEntry : simpleFileEntries) {
                Path dataFilePath = pathFactory.createDataFilePathFactory(simpleFileEntry.partition(), simpleFileEntry.bucket()).toPath(simpleFileEntry);
                dataFiles.add(dataFilePath);
            }
            Collections.reverse(dataFiles);
            files.addAll(dataFiles);
            String indexManifest = snapshot.indexManifest();
            if (indexManifest != null && indexFileHandler.existsManifest(indexManifest)) {
                files.add(pathFactory.indexManifestFileFactory().toPath(indexManifest));
                List indexManifestEntries = PickFilesUtil.retryReadingFiles(() -> indexFileHandler.readManifestWithIOException(indexManifest));
                if (indexManifestEntries == null) {
                    return Collections.emptyList();
                }
                indexManifestEntries.stream().map(IndexManifestEntry::indexFile).map(indexFileHandler::filePath).forEach(files::add);
            }
            if (snapshot.statistics() != null) {
                files.add(pathFactory.statsFileFactory().toPath(snapshot.statistics()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    private static void addManifestList(List<Path> used, Snapshot snapshot, FileStorePathFactory pathFactory) {
        used.add(pathFactory.toManifestListPath(snapshot.baseManifestList()));
        used.add(pathFactory.toManifestListPath(snapshot.deltaManifestList()));
        String changelogManifestList = snapshot.changelogManifestList();
        if (changelogManifestList != null) {
            used.add(pathFactory.toManifestListPath(changelogManifestList));
        }
    }

    private static List<ManifestFileMeta> readAllManifestsWithIOException(Snapshot snapshot, ManifestList manifestList) throws IOException {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(manifestList.readWithIOException(snapshot.baseManifestList()));
        result.addAll(manifestList.readWithIOException(snapshot.deltaManifestList()));
        String changelogManifestList = snapshot.changelogManifestList();
        if (changelogManifestList != null) {
            result.addAll(manifestList.readWithIOException(changelogManifestList));
        }
        return result;
    }

    @Nullable
    private static <T> T retryReadingFiles(SupplierWithIOException<T> reader) throws IOException {
        int retryNumber = 0;
        IOException caught = null;
        while (retryNumber++ < 3) {
            try {
                return reader.get();
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                caught = e;
                try {
                    TimeUnit.MILLISECONDS.sleep(5L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
        throw caught;
    }
}

