/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact.changelog.format;

import java.io.EOFException;
import java.io.IOException;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.reader.FileRecordReader;

public class CompactedChangelogFormatReaderFactory
implements FormatReaderFactory {
    private final FormatReaderFactory wrapped;

    public CompactedChangelogFormatReaderFactory(FormatReaderFactory wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public FileRecordReader<InternalRow> createReader(final FormatReaderFactory.Context context) throws IOException {
        final OffsetReadOnlyFileIO fileIO = new OffsetReadOnlyFileIO(context.fileIO());
        final long length = CompactedChangelogFormatReaderFactory.decodePath(context.filePath()).length;
        return this.wrapped.createReader(new FormatReaderFactory.Context(){

            @Override
            public FileIO fileIO() {
                return fileIO;
            }

            @Override
            public Path filePath() {
                return context.filePath();
            }

            @Override
            public long fileSize() {
                return length;
            }

            @Override
            public FileIndexResult fileIndex() {
                return context.fileIndex();
            }
        });
    }

    private static DecodeResult decodePath(Path path) {
        String[] nameAndFormat = path.getName().split("\\.");
        String[] names = nameAndFormat[0].split("\\$");
        String[] split = names[1].split("-");
        if (split.length == 2) {
            return new DecodeResult(path, 0L, Long.parseLong(split[1]));
        }
        Path realPath = new Path(path.getParent().getParent(), "bucket-" + split[0] + "/" + names[0] + "$" + split[0] + "-" + split[1] + "." + nameAndFormat[1]);
        return new DecodeResult(realPath, Long.parseLong(split[2]), Long.parseLong(split[3]));
    }

    private static class OffsetSeekableInputStream
    extends SeekableInputStream {
        private final SeekableInputStream wrapped;
        private final long offset;
        private final long length;

        private OffsetSeekableInputStream(SeekableInputStream wrapped, long offset, long length) throws IOException {
            this.wrapped = wrapped;
            this.offset = offset;
            this.length = length;
            wrapped.seek(offset);
        }

        @Override
        public void seek(long desired) throws IOException {
            this.wrapped.seek(this.offset + desired);
        }

        @Override
        public long getPos() throws IOException {
            return this.wrapped.getPos() - this.offset;
        }

        @Override
        public int read() throws IOException {
            if (this.getPos() >= this.length) {
                throw new EOFException();
            }
            return this.wrapped.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            long realLen = Math.min((long)len, this.length - this.getPos());
            return this.wrapped.read(b, off, (int)realLen);
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }
    }

    private static class OffsetReadOnlyFileIO
    implements FileIO {
        private final FileIO wrapped;

        private OffsetReadOnlyFileIO(FileIO wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isObjectStore() {
            return this.wrapped.isObjectStore();
        }

        @Override
        public void configure(CatalogContext context) {
            this.wrapped.configure(context);
        }

        @Override
        public SeekableInputStream newInputStream(Path path) throws IOException {
            DecodeResult result = CompactedChangelogFormatReaderFactory.decodePath(path);
            return new OffsetSeekableInputStream(this.wrapped.newInputStream(result.path), result.offset, result.length);
        }

        @Override
        public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileStatus getFileStatus(final Path path) throws IOException {
            final DecodeResult result = CompactedChangelogFormatReaderFactory.decodePath(path);
            final FileStatus status = this.wrapped.getFileStatus(result.path);
            return new FileStatus(){

                @Override
                public long getLen() {
                    return result.length;
                }

                @Override
                public boolean isDir() {
                    return status.isDir();
                }

                @Override
                public Path getPath() {
                    return path;
                }

                @Override
                public long getModificationTime() {
                    return status.getModificationTime();
                }
            };
        }

        @Override
        public FileStatus[] listStatus(Path path) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean exists(Path path) throws IOException {
            return this.wrapped.exists(CompactedChangelogFormatReaderFactory.decodePath(path).path);
        }

        @Override
        public boolean delete(Path path, boolean recursive) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mkdirs(Path path) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean rename(Path src, Path dst) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DecodeResult {
        private final Path path;
        private final long offset;
        private final long length;

        private DecodeResult(Path path, long offset, long length) {
            this.path = path;
            this.offset = offset;
            this.length = length;
        }
    }
}

