/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.flink.lookup.IncrementalCompactDiffSplitRead;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.AbstractDataTableRead;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.RowType;

public class LookupCompactDiffRead
extends AbstractDataTableRead<KeyValue> {
    private final SplitRead<InternalRow> fullPhaseMergeRead;
    private final SplitRead<InternalRow> incrementalDiffRead;

    public LookupCompactDiffRead(MergeFileSplitRead mergeRead, TableSchema schema) {
        super(schema);
        this.incrementalDiffRead = new IncrementalCompactDiffSplitRead(mergeRead);
        this.fullPhaseMergeRead = SplitRead.convert(mergeRead, split -> KeyValueTableRead.unwrap(mergeRead.createReader((DataSplit)split)));
    }

    @Override
    public void applyReadType(RowType readType) {
        this.fullPhaseMergeRead.withReadType(readType);
        this.incrementalDiffRead.withReadType(readType);
    }

    @Override
    public RecordReader<InternalRow> reader(Split split) throws IOException {
        DataSplit dataSplit = (DataSplit)split;
        if (dataSplit.beforeFiles().isEmpty()) {
            return this.fullPhaseMergeRead.createReader(dataSplit);
        }
        return this.incrementalDiffRead.createReader((DataSplit)split);
    }

    @Override
    protected InnerTableRead innerWithFilter(Predicate predicate) {
        this.fullPhaseMergeRead.withFilter(predicate);
        this.incrementalDiffRead.withFilter(predicate);
        return this;
    }

    @Override
    public InnerTableRead forceKeepDelete() {
        this.fullPhaseMergeRead.forceKeepDelete();
        this.incrementalDiffRead.forceKeepDelete();
        return this;
    }

    @Override
    public TableRead withIOManager(IOManager ioManager) {
        this.fullPhaseMergeRead.withIOManager(ioManager);
        this.incrementalDiffRead.withIOManager(ioManager);
        return this;
    }
}

