/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.TimeUtils;

public class ExpirePartitionsProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "expire_partitions";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy) throws Catalog.TableNotExistException {
        return this.call(procedureContext, tableId, expirationTime, timestampFormatter, timestampPattern, expireStrategy, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy, Integer maxExpires) throws Catalog.TableNotExistException {
        String[] stringArray;
        List<Map<String, String>> expired;
        FileStoreTable fileStoreTable = (FileStoreTable)this.table(tableId);
        FileStore<?> fileStore = fileStoreTable.store();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CoreOptions.PARTITION_EXPIRATION_STRATEGY.key(), expireStrategy);
        map.put(CoreOptions.PARTITION_TIMESTAMP_FORMATTER.key(), timestampFormatter);
        map.put(CoreOptions.PARTITION_TIMESTAMP_PATTERN.key(), timestampPattern);
        PartitionExpire partitionExpire = new PartitionExpire(TimeUtils.parseDuration(expirationTime), Duration.ofMillis(0L), PartitionExpireStrategy.createPartitionExpireStrategy(CoreOptions.fromMap(map), fileStore.partitionType()), fileStore.newScan(), fileStore.newCommit(""), Optional.ofNullable(fileStoreTable.catalogEnvironment().metastoreClientFactory()).map(MetastoreClient.Factory::create).orElse(null), fileStore.options().partitionExpireMaxNum());
        if (maxExpires != null) {
            partitionExpire.withMaxExpireNum(maxExpires);
        }
        if ((expired = partitionExpire.expire(Long.MAX_VALUE)) == null || expired.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "No expired partitions.";
        } else {
            stringArray = (String[])expired.stream().map(x -> {
                String r = x.toString();
                return r.substring(1, r.length() - 1);
            }).toArray(String[]::new);
        }
        return stringArray;
    }
}

