/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateTableProcedure
extends ProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateTableProcedure.class);
    private static final String PAIMON_SUFFIX = "_paimon_";

    @Override
    public String identifier() {
        return "migrate_table";
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath) throws Exception {
        return this.call(procedureContext, connector, sourceTablePath, "");
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String properties) throws Exception {
        String targetPaimonTablePath = sourceTablePath + PAIMON_SUFFIX;
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetPaimonTablePath);
        TableMigrationUtils.getImporter(connector, this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), Runtime.getRuntime().availableProcessors(), ParameterUtils.parseCommaSeparatedKeyValues(properties)).executeMigrate();
        LOG.info("Last step: rename " + targetTableId + " to " + sourceTableId);
        this.catalog.renameTable(targetTableId, sourceTableId, false);
        return new String[]{"Success"};
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String properties, Integer parallelism) throws Exception {
        String targetPaimonTablePath = sourceTablePath + PAIMON_SUFFIX;
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetPaimonTablePath);
        TableMigrationUtils.getImporter(connector, this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), parallelism, ParameterUtils.parseCommaSeparatedKeyValues(properties)).executeMigrate();
        LOG.info("Last step: rename " + targetTableId + " to " + sourceTableId);
        this.catalog.renameTable(targetTableId, sourceTableId, false);
        return new String[]{"Success"};
    }
}

