/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.consumer.Consumer;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;

public class ResetConsumerProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "reset_consumer";

    public String[] call(ProcedureContext procedureContext, String tableId, String consumerId, long nextSnapshotId) throws Catalog.TableNotExistException {
        FileStoreTable fileStoreTable = (FileStoreTable)this.catalog.getTable(Identifier.fromString(tableId));
        fileStoreTable.snapshotManager().snapshot(nextSnapshotId);
        ConsumerManager consumerManager = new ConsumerManager(fileStoreTable.fileIO(), fileStoreTable.location(), fileStoreTable.snapshotManager().branch());
        consumerManager.resetConsumer(consumerId, new Consumer(nextSnapshotId));
        return new String[]{"Success"};
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String consumerId) throws Catalog.TableNotExistException {
        FileStoreTable fileStoreTable = (FileStoreTable)this.catalog.getTable(Identifier.fromString(tableId));
        ConsumerManager consumerManager = new ConsumerManager(fileStoreTable.fileIO(), fileStoreTable.location(), fileStoreTable.snapshotManager().branch());
        consumerManager.deleteConsumer(consumerId);
        return new String[]{"Success"};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

