/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;

@Experimental
public class RichCdcRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CdcRecord cdcRecord;
    private final List<DataField> fields;

    public RichCdcRecord(CdcRecord cdcRecord, List<DataField> fields) {
        this.cdcRecord = cdcRecord;
        this.fields = fields;
    }

    public boolean hasPayload() {
        return !this.cdcRecord.data().isEmpty();
    }

    public RowKind kind() {
        return this.cdcRecord.kind();
    }

    public List<DataField> fields() {
        return this.fields;
    }

    public CdcRecord toCdcRecord() {
        return this.cdcRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichCdcRecord that = (RichCdcRecord)o;
        return this.cdcRecord == that.cdcRecord && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.cdcRecord, this.fields);
    }

    public String toString() {
        return "{cdcRecord=" + this.cdcRecord + ", fields=" + this.fields + '}';
    }

    public static Builder builder(RowKind kind) {
        return new Builder(kind, new AtomicInteger(-1));
    }

    public static class Builder {
        private final RowKind kind;
        private final AtomicInteger fieldId;
        private final List<DataField> fields = new ArrayList<DataField>();
        private final Map<String, String> data = new HashMap<String, String>();

        public Builder(RowKind kind, AtomicInteger fieldId) {
            this.kind = kind;
            this.fieldId = fieldId;
        }

        public Builder field(String name, DataType type, String value) {
            return this.field(name, type, value, null);
        }

        public Builder field(String name, DataType type, String value, @Nullable String description) {
            this.fields.add(new DataField(this.fieldId.incrementAndGet(), name, type, description));
            this.data.put(name, value);
            return this;
        }

        public RichCdcRecord build() {
            return new RichCdcRecord(new CdcRecord(this.kind, this.data), this.fields);
        }
    }
}

