/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.data.columnar.VectorizedRowIterator;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.OrcFormatReaderContext;
import org.apache.paimon.format.fs.HadoopReadOnlyFileSystem;
import org.apache.paimon.format.orc.OrcTypeUtil;
import org.apache.paimon.format.orc.filter.OrcFilters;
import org.apache.paimon.format.orc.reader.AbstractOrcColumnVector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.paimon.shade.org.apache.orc.OrcConf;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.Reader;
import org.apache.paimon.shade.org.apache.orc.RecordReader;
import org.apache.paimon.shade.org.apache.orc.StripeInformation;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.ReaderImpl;
import org.apache.paimon.shade.org.apache.orc.impl.RecordReaderImpl;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Pool;
import org.apache.paimon.utils.Preconditions;

public class OrcReaderFactory
implements FormatReaderFactory {
    protected final Configuration hadoopConfig;
    protected final TypeDescription schema;
    protected final RowType tableType;
    protected final List<OrcFilters.Predicate> conjunctPredicates;
    protected final int batchSize;
    protected final boolean deletionVectorsEnabled;

    public OrcReaderFactory(Configuration hadoopConfig, RowType readType, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, boolean deletionVectorsEnabled) {
        this.hadoopConfig = Preconditions.checkNotNull(hadoopConfig);
        this.schema = OrcTypeUtil.convertToOrcSchema(readType);
        this.tableType = readType;
        this.conjunctPredicates = Preconditions.checkNotNull(conjunctPredicates);
        this.batchSize = batchSize;
        this.deletionVectorsEnabled = deletionVectorsEnabled;
    }

    public OrcVectorizedReader createReader(FormatReaderFactory.Context context) throws IOException {
        int poolSize = context instanceof OrcFormatReaderContext ? ((OrcFormatReaderContext)context).poolSize() : 1;
        Pool<OrcReaderBatch> poolOfBatches = this.createPoolOfBatches(context.filePath(), poolSize);
        RecordReader orcReader = OrcReaderFactory.createRecordReader(this.hadoopConfig, this.schema, this.conjunctPredicates, context.fileIO(), context.filePath(), 0L, context.fileSize(), context.fileIndex(), this.deletionVectorsEnabled);
        return new OrcVectorizedReader(orcReader, poolOfBatches);
    }

    public OrcReaderBatch createReaderBatch(Path filePath, VectorizedRowBatch orcBatch, Pool.Recycler<OrcReaderBatch> recycler) {
        List<String> tableFieldNames = this.tableType.getFieldNames();
        List<DataType> tableFieldTypes = this.tableType.getFieldTypes();
        ColumnVector[] vectors = new ColumnVector[this.tableType.getFieldCount()];
        for (int i = 0; i < vectors.length; ++i) {
            String name = tableFieldNames.get(i);
            DataType type = tableFieldTypes.get(i);
            vectors[i] = AbstractOrcColumnVector.createPaimonVector(orcBatch.cols[tableFieldNames.indexOf(name)], orcBatch, type);
        }
        return new OrcReaderBatch(filePath, orcBatch, new VectorizedColumnBatch(vectors), recycler);
    }

    private Pool<OrcReaderBatch> createPoolOfBatches(Path filePath, int numBatches) {
        Pool<OrcReaderBatch> pool = new Pool<OrcReaderBatch>(numBatches);
        for (int i = 0; i < numBatches; ++i) {
            VectorizedRowBatch orcBatch = OrcReaderFactory.createBatchWrapper(this.schema, this.batchSize / numBatches);
            OrcReaderBatch batch = this.createReaderBatch(filePath, orcBatch, pool.recycler());
            pool.add(batch);
        }
        return pool;
    }

    private static RecordReader createRecordReader(Configuration conf, TypeDescription schema, List<OrcFilters.Predicate> conjunctPredicates, FileIO fileIO, Path path, long splitStart, long splitLength, @Nullable FileIndexResult fileIndexResult, boolean deletionVectorsEnabled) throws IOException {
        Reader orcReader = OrcReaderFactory.createReader(conf, fileIO, path, fileIndexResult);
        try {
            Pair<Long, Long> offsetAndLength = OrcReaderFactory.getOffsetAndLengthForSplit(splitStart, splitLength, orcReader.getStripes());
            Reader.Options options = new Reader.Options().schema(schema).range(offsetAndLength.getLeft(), offsetAndLength.getRight()).useZeroCopy(OrcConf.USE_ZEROCOPY.getBoolean(conf)).skipCorruptRecords(OrcConf.SKIP_CORRUPT_DATA.getBoolean(conf)).tolerateMissingSchema(OrcConf.TOLERATE_MISSING_SCHEMA.getBoolean(conf));
            if (!(conjunctPredicates.isEmpty() || deletionVectorsEnabled || fileIndexResult instanceof BitmapIndexResult)) {
                options.useSelected(OrcConf.READER_USE_SELECTED.getBoolean(conf));
                options.allowSARGToFilter(OrcConf.ALLOW_SARG_TO_FILTER.getBoolean(conf));
            }
            if (!conjunctPredicates.isEmpty()) {
                SearchArgument.Builder b = SearchArgumentFactory.newBuilder();
                b = b.startAnd();
                for (OrcFilters.Predicate predicate : conjunctPredicates) {
                    predicate.add(b);
                }
                b = b.end();
                options.searchArgument(b.build(), new String[0]);
            }
            RecordReader orcRowsReader = orcReader.rows(options);
            schema.getId();
            return orcRowsReader;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(orcReader);
            throw e;
        }
    }

    private static VectorizedRowBatch createBatchWrapper(TypeDescription schema, int batchSize) {
        return schema.createRowBatch(batchSize);
    }

    private static boolean nextBatch(RecordReader reader, VectorizedRowBatch rowBatch) throws IOException {
        return reader.nextBatch(rowBatch);
    }

    private static Pair<Long, Long> getOffsetAndLengthForSplit(long splitStart, long splitLength, List<StripeInformation> stripes) {
        long splitEnd = splitStart + splitLength;
        long readStart = Long.MAX_VALUE;
        long readEnd = Long.MIN_VALUE;
        for (StripeInformation s : stripes) {
            if (splitStart > s.getOffset() || s.getOffset() >= splitEnd) continue;
            readStart = Math.min(readStart, s.getOffset());
            readEnd = Math.max(readEnd, s.getOffset() + s.getLength());
        }
        if (readStart < Long.MAX_VALUE) {
            return Pair.of(readStart, readEnd - readStart);
        }
        return Pair.of(0L, 0L);
    }

    public static Reader createReader(Configuration conf, FileIO fileIO, Path path, final @Nullable FileIndexResult fileIndexResult) throws IOException {
        org.apache.hadoop.fs.Path hPath = new org.apache.hadoop.fs.Path(path.toUri());
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(conf);
        readerOptions.filesystem(new HadoopReadOnlyFileSystem(fileIO));
        return new ReaderImpl(hPath, readerOptions){

            @Override
            public RecordReader rows(Reader.Options options) throws IOException {
                return new RecordReaderImpl(this, options, fileIndexResult);
            }
        };
    }

    private static final class OrcVectorizedReader
    implements FileRecordReader<InternalRow> {
        private final RecordReader orcReader;
        private final Pool<OrcReaderBatch> pool;

        private OrcVectorizedReader(RecordReader orcReader, Pool<OrcReaderBatch> pool) {
            this.orcReader = Preconditions.checkNotNull(orcReader, "orcReader");
            this.pool = Preconditions.checkNotNull(pool, "pool");
        }

        @Override
        @Nullable
        public ColumnarRowIterator readBatch() throws IOException {
            OrcReaderBatch batch = this.getCachedEntry();
            VectorizedRowBatch orcVectorBatch = batch.orcVectorizedRowBatch();
            long rowNumber = this.orcReader.getRowNumber();
            if (!OrcReaderFactory.nextBatch(this.orcReader, orcVectorBatch)) {
                batch.recycle();
                return null;
            }
            return batch.convertAndGetIterator(orcVectorBatch, rowNumber);
        }

        @Override
        public void close() throws IOException {
            this.orcReader.close();
        }

        private OrcReaderBatch getCachedEntry() throws IOException {
            try {
                return this.pool.pollEntry();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted");
            }
        }
    }

    private static class OrcReaderBatch {
        private final VectorizedRowBatch orcVectorizedRowBatch;
        private final Pool.Recycler<OrcReaderBatch> recycler;
        private final VectorizedColumnBatch paimonColumnBatch;
        private final VectorizedRowIterator result;

        protected OrcReaderBatch(Path filePath, VectorizedRowBatch orcVectorizedRowBatch, VectorizedColumnBatch paimonColumnBatch, Pool.Recycler<OrcReaderBatch> recycler) {
            this.orcVectorizedRowBatch = Preconditions.checkNotNull(orcVectorizedRowBatch);
            this.recycler = Preconditions.checkNotNull(recycler);
            this.paimonColumnBatch = paimonColumnBatch;
            this.result = new VectorizedRowIterator(filePath, new ColumnarRow(paimonColumnBatch), this::recycle);
        }

        public void recycle() {
            this.recycler.recycle(this);
        }

        public VectorizedRowBatch orcVectorizedRowBatch() {
            return this.orcVectorizedRowBatch;
        }

        private ColumnarRowIterator convertAndGetIterator(VectorizedRowBatch orcBatch, long rowNumber) {
            this.paimonColumnBatch.setNumRows(orcBatch.size);
            this.result.reset(rowNumber);
            return this.result;
        }
    }
}

