/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.heap.ElementCountable;
import org.apache.paimon.data.columnar.heap.HeapArrayVector;
import org.apache.paimon.data.columnar.heap.HeapMapVector;
import org.apache.paimon.data.columnar.heap.HeapRowVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.position.CollectionPosition;
import org.apache.paimon.format.parquet.position.LevelDelegation;
import org.apache.paimon.format.parquet.position.RowPosition;
import org.apache.paimon.format.parquet.reader.ColumnReader;
import org.apache.paimon.format.parquet.reader.NestedPositionUtil;
import org.apache.paimon.format.parquet.reader.NestedPrimitiveColumnReader;
import org.apache.paimon.format.parquet.type.ParquetField;
import org.apache.paimon.format.parquet.type.ParquetGroupField;
import org.apache.paimon.format.parquet.type.ParquetPrimitiveField;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class NestedColumnReader
implements ColumnReader<WritableColumnVector> {
    private final Map<ColumnDescriptor, NestedPrimitiveColumnReader> columnReaders;
    private final boolean isUtcTimestamp;
    private final PageReadStore pages;
    private final ParquetField field;

    public NestedColumnReader(boolean isUtcTimestamp, PageReadStore pages, ParquetField field) {
        this.isUtcTimestamp = isUtcTimestamp;
        this.pages = pages;
        this.field = field;
        this.columnReaders = new HashMap<ColumnDescriptor, NestedPrimitiveColumnReader>();
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        this.readData(this.field, readNumber, vector, false);
    }

    private Pair<LevelDelegation, WritableColumnVector> readData(ParquetField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        if (field.getType() instanceof RowType) {
            return this.readRow((ParquetGroupField)field, readNumber, vector, inside);
        }
        if (field.getType() instanceof MapType || field.getType() instanceof MultisetType) {
            return this.readMap((ParquetGroupField)field, readNumber, vector, inside);
        }
        if (field.getType() instanceof ArrayType) {
            return this.readArray((ParquetGroupField)field, readNumber, vector, inside);
        }
        return this.readPrimitive((ParquetPrimitiveField)field, readNumber, vector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readRow(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapRowVector heapRowVector = (HeapRowVector)vector;
        LevelDelegation levelDelegation = null;
        List<ParquetField> children = field.getChildren();
        WritableColumnVector[] childrenVectors = (WritableColumnVector[])heapRowVector.getChildren();
        ColumnVector[] finalChildrenVectors = new WritableColumnVector[childrenVectors.length];
        int len = -1;
        boolean[] isNull = null;
        boolean hasNull = false;
        for (int i = 0; i < children.size(); ++i) {
            Pair<LevelDelegation, WritableColumnVector> tuple = this.readData(children.get(i), readNumber, childrenVectors[i], true);
            levelDelegation = tuple.getLeft();
            finalChildrenVectors[i] = tuple.getRight();
            WritableColumnVector writableColumnVector = tuple.getRight();
            if (len == -1) {
                len = ((ElementCountable)((Object)writableColumnVector)).getCapacity();
                isNull = new boolean[len];
                Arrays.fill(isNull, true);
            }
            for (int j = 0; j < len; ++j) {
                boolean bl = isNull[j] = isNull[j] && writableColumnVector.isNullAt(j);
                if (!isNull[j]) continue;
                hasNull = true;
            }
        }
        if (levelDelegation == null) {
            throw new RuntimeException(String.format("Row field does not have any children: %s.", field));
        }
        RowPosition rowPosition = NestedPositionUtil.calculateRowOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel());
        if (inside) {
            heapRowVector = new HeapRowVector(rowPosition.getPositionsCount(), finalChildrenVectors);
        } else {
            heapRowVector.setFields((WritableColumnVector[])finalChildrenVectors);
        }
        if (hasNull) {
            NestedColumnReader.setFieldNullFlag(isNull, heapRowVector);
        }
        return Pair.of(levelDelegation, heapRowVector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readMap(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapMapVector mapVector = (HeapMapVector)vector;
        mapVector.reset();
        List<ParquetField> children = field.getChildren();
        Preconditions.checkArgument(children.size() == 2, "Maps must have two type parameters, found %s", children.size());
        Pair<LevelDelegation, WritableColumnVector> keyTuple = this.readData(children.get(0), readNumber, mapVector.getChildren()[0], true);
        Pair<LevelDelegation, WritableColumnVector> valueTuple = this.readData(children.get(1), readNumber, mapVector.getChildren()[1], true);
        LevelDelegation levelDelegation = keyTuple.getLeft();
        CollectionPosition collectionPosition = NestedPositionUtil.calculateCollectionOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel());
        if (inside) {
            mapVector = new HeapMapVector(collectionPosition.getValueCount(), keyTuple.getRight(), valueTuple.getRight());
        } else {
            mapVector.setKeys(keyTuple.getRight());
            mapVector.setValues(valueTuple.getRight());
        }
        if (collectionPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFlag(collectionPosition.getIsNull(), mapVector);
        }
        mapVector.setLengths(collectionPosition.getLength());
        mapVector.setOffsets(collectionPosition.getOffsets());
        return Pair.of(levelDelegation, mapVector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readArray(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapArrayVector arrayVector = (HeapArrayVector)vector;
        arrayVector.reset();
        List<ParquetField> children = field.getChildren();
        Preconditions.checkArgument(children.size() == 1, "Arrays must have a single type parameter, found %s", children.size());
        Pair<LevelDelegation, WritableColumnVector> tuple = this.readData(children.get(0), readNumber, arrayVector.getChildren()[0], true);
        LevelDelegation levelDelegation = tuple.getLeft();
        CollectionPosition collectionPosition = NestedPositionUtil.calculateCollectionOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel());
        if (inside) {
            arrayVector = new HeapArrayVector(collectionPosition.getValueCount(), tuple.getRight());
        } else {
            arrayVector.setChild(tuple.getRight());
        }
        if (collectionPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFlag(collectionPosition.getIsNull(), arrayVector);
        }
        arrayVector.setLengths(collectionPosition.getLength());
        arrayVector.setOffsets(collectionPosition.getOffsets());
        return Pair.of(levelDelegation, arrayVector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readPrimitive(ParquetPrimitiveField field, int readNumber, ColumnVector vector) throws IOException {
        ColumnDescriptor descriptor = field.getDescriptor();
        NestedPrimitiveColumnReader reader = this.columnReaders.get(descriptor);
        if (reader == null) {
            reader = new NestedPrimitiveColumnReader(descriptor, this.pages, this.isUtcTimestamp, descriptor.getPrimitiveType(), field.getType());
            this.columnReaders.put(descriptor, reader);
        }
        WritableColumnVector writableColumnVector = reader.readAndNewVector(readNumber, (WritableColumnVector)vector);
        return Pair.of(reader.getLevelDelegation(), writableColumnVector);
    }

    private static void setFieldNullFlag(boolean[] nullFlags, AbstractHeapVector vector) {
        for (int index = 0; index < vector.getCapacity() && index < nullFlags.length; ++index) {
            if (!nullFlags[index]) continue;
            vector.setNullAt(index);
        }
    }
}

