/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;

public class IcebergOptions {
    public static final ConfigOption<StorageType> METADATA_ICEBERG_STORAGE = ConfigOptions.key("metadata.iceberg.storage").enumType(StorageType.class).defaultValue(StorageType.DISABLED).withDescription("When set, produce Iceberg metadata after a snapshot is committed, so that Iceberg readers can read Paimon's raw data files.");
    public static final ConfigOption<Integer> COMPACT_MIN_FILE_NUM = ConfigOptions.key("metadata.iceberg.compaction.min.file-num").intType().defaultValue(10).withDescription("Minimum number of Iceberg metadata files to trigger metadata compaction.");
    public static final ConfigOption<Integer> COMPACT_MAX_FILE_NUM = ConfigOptions.key("metadata.iceberg.compaction.max.file-num").intType().defaultValue(50).withDescription("If number of small Iceberg metadata files exceeds this limit, always trigger metadata compaction regardless of their total size.");
    public static final ConfigOption<String> URI = ConfigOptions.key("metadata.iceberg.uri").stringType().noDefaultValue().withDescription("Hive metastore uri for Iceberg Hive catalog.");
    public static final ConfigOption<String> HIVE_CONF_DIR = ConfigOptions.key("metadata.iceberg.hive-conf-dir").stringType().noDefaultValue().withDescription("hive-conf-dir for Iceberg Hive catalog.");
    public static final ConfigOption<String> HADOOP_CONF_DIR = ConfigOptions.key("metadata.iceberg.hadoop-conf-dir").stringType().noDefaultValue().withDescription("hadoop-conf-dir for Iceberg Hive catalog.");
    public static final ConfigOption<String> MANIFEST_COMPRESSION = ConfigOptions.key("metadata.iceberg.manifest-compression").stringType().defaultValue("snappy").withDescription("Compression for Iceberg manifest files.");
    public static final ConfigOption<Boolean> MANIFEST_LEGACY_VERSION = ConfigOptions.key("metadata.iceberg.manifest-legacy-version").booleanType().defaultValue(false).withDescription("Should use the legacy manifest version to generate Iceberg's 1.4 manifest files.");
    public static final ConfigOption<String> HIVE_CLIENT_CLASS = ConfigOptions.key("metadata.iceberg.hive-client-class").stringType().defaultValue("org.apache.hadoop.hive.metastore.HiveMetaStoreClient").withDescription("Hive client class name for Iceberg Hive Catalog.");

    public static enum StorageType implements DescribedEnum
    {
        DISABLED("disabled", "Disable Iceberg compatibility support."),
        TABLE_LOCATION("table-location", "Store Iceberg metadata in each table's directory."),
        HADOOP_CATALOG("hadoop-catalog", "Store Iceberg metadata in a separate directory. This directory can be specified as the warehouse directory of an Iceberg Hadoop catalog."),
        HIVE_CATALOG("hive-catalog", "Not only store Iceberg metadata like hadoop-catalog, but also create Iceberg external table in Hive.");

        private final String value;
        private final String description;

        private StorageType(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }
}

