/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.paimon.privilege.PrivilegeType;

public class NoPrivilegeException
extends RuntimeException {
    private final String user;
    private final String objectType;
    private final String identifier;

    public NoPrivilegeException(String user, String objectType, String identifier, PrivilegeType ... privilege) {
        super(String.format("User %s doesn't have privilege %s on %s %s", user, Arrays.stream(privilege).map(Enum::name).collect(Collectors.joining(" or ")), objectType, identifier));
        this.user = user;
        this.objectType = objectType;
        this.identifier = identifier;
    }

    String getUser() {
        return this.user;
    }

    String getObjectType() {
        return this.objectType;
    }

    String getIdentifier() {
        return this.identifier;
    }
}

