/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.rest.DefaultErrorHandler;
import org.apache.paimon.rest.HttpClient;
import org.apache.paimon.rest.HttpClientOptions;
import org.apache.paimon.rest.RESTCatalogInternalOptions;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.RESTClient;
import org.apache.paimon.rest.RESTObjectMapper;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.ResourcePaths;
import org.apache.paimon.rest.auth.AuthSession;
import org.apache.paimon.rest.auth.CredentialsProvider;
import org.apache.paimon.rest.auth.CredentialsProviderFactory;
import org.apache.paimon.rest.exceptions.AlreadyExistsException;
import org.apache.paimon.rest.exceptions.NoSuchResourceException;
import org.apache.paimon.rest.requests.AlterDatabaseRequest;
import org.apache.paimon.rest.requests.CreateDatabaseRequest;
import org.apache.paimon.rest.responses.AlterDatabaseResponse;
import org.apache.paimon.rest.responses.ConfigResponse;
import org.apache.paimon.rest.responses.CreateDatabaseResponse;
import org.apache.paimon.rest.responses.DatabaseName;
import org.apache.paimon.rest.responses.GetDatabaseResponse;
import org.apache.paimon.rest.responses.ListDatabasesResponse;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.shade.guava30.com.google.common.annotations.VisibleForTesting;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.ThreadPoolUtils;

public class RESTCatalog
implements Catalog {
    private static final ObjectMapper OBJECT_MAPPER = RESTObjectMapper.create();
    private final RESTClient client;
    private final ResourcePaths resourcePaths;
    private final Options options;
    private final Map<String, String> baseHeader;
    private final AuthSession catalogAuth;
    private volatile ScheduledExecutorService refreshExecutor = null;

    public RESTCatalog(Options options) {
        if (options.getOptional(CatalogOptions.WAREHOUSE).isPresent()) {
            throw new IllegalArgumentException("Can not config warehouse in RESTCatalog.");
        }
        String uri = options.get(RESTCatalogOptions.URI);
        Optional<Duration> connectTimeout = options.getOptional(RESTCatalogOptions.CONNECTION_TIMEOUT);
        Optional<Duration> readTimeout = options.getOptional(RESTCatalogOptions.READ_TIMEOUT);
        Integer threadPoolSize = options.get(RESTCatalogOptions.THREAD_POOL_SIZE);
        HttpClientOptions httpClientOptions = new HttpClientOptions(uri, connectTimeout, readTimeout, OBJECT_MAPPER, threadPoolSize, DefaultErrorHandler.getInstance());
        this.client = new HttpClient(httpClientOptions);
        this.baseHeader = RESTCatalog.configHeaders(options.toMap());
        CredentialsProvider credentialsProvider = CredentialsProviderFactory.createCredentialsProvider(options, RESTCatalog.class.getClassLoader());
        this.catalogAuth = credentialsProvider.keepRefreshed() ? AuthSession.fromRefreshCredentialsProvider(this.tokenRefreshExecutor(), this.baseHeader, credentialsProvider) : new AuthSession(this.baseHeader, credentialsProvider);
        Map<String, String> initHeaders = RESTUtil.merge(RESTCatalog.configHeaders(options.toMap()), this.catalogAuth.getHeaders());
        this.options = new Options(this.fetchOptionsFromServer(initHeaders, options.toMap()));
        this.resourcePaths = ResourcePaths.forCatalogProperties(this.options.get(RESTCatalogInternalOptions.PREFIX));
    }

    @Override
    public String warehouse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> options() {
        return this.options.toMap();
    }

    @Override
    public FileIO fileIO() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listDatabases() {
        ListDatabasesResponse response = this.client.get(this.resourcePaths.databases(), ListDatabasesResponse.class, this.headers());
        if (response.getDatabases() != null) {
            return response.getDatabases().stream().map(DatabaseName::getName).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists, Map<String, String> properties) throws Catalog.DatabaseAlreadyExistException {
        block2: {
            CreateDatabaseRequest request = new CreateDatabaseRequest(name, properties);
            try {
                this.client.post(this.resourcePaths.databases(), request, CreateDatabaseResponse.class, this.headers());
            }
            catch (AlreadyExistsException e) {
                if (ignoreIfExists) break block2;
                throw new Catalog.DatabaseAlreadyExistException(name);
            }
        }
    }

    @Override
    public Database getDatabase(String name) throws Catalog.DatabaseNotExistException {
        try {
            GetDatabaseResponse response = this.client.get(this.resourcePaths.database(name), GetDatabaseResponse.class, this.headers());
            return new Database.DatabaseImpl(name, response.options(), response.comment().orElseGet(() -> null));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(name);
        }
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        block3: {
            try {
                if (!cascade && !this.listTables(name).isEmpty()) {
                    throw new Catalog.DatabaseNotEmptyException(name);
                }
                this.client.delete(this.resourcePaths.database(name), this.headers());
            }
            catch (NoSuchResourceException e) {
                if (ignoreIfNotExists) break block3;
                throw new Catalog.DatabaseNotExistException(name);
            }
        }
    }

    @Override
    public void alterDatabase(String name, List<PropertyChange> changes, boolean ignoreIfNotExists) throws Catalog.DatabaseNotExistException {
        block3: {
            try {
                Pair<Map<String, String>, Set<String>> setPropertiesToRemoveKeys = PropertyChange.getSetPropertiesToRemoveKeys(changes);
                Map<String, String> updateProperties = setPropertiesToRemoveKeys.getLeft();
                Set<String> removeKeys = setPropertiesToRemoveKeys.getRight();
                AlterDatabaseRequest request = new AlterDatabaseRequest(new ArrayList<String>(removeKeys), updateProperties);
                AlterDatabaseResponse response = this.client.post(this.resourcePaths.databaseProperties(name), request, AlterDatabaseResponse.class, this.headers());
                if (response.getUpdated().isEmpty()) {
                    throw new IllegalStateException("Failed to update properties");
                }
            }
            catch (NoSuchResourceException e) {
                if (ignoreIfNotExists) break block3;
                throw new Catalog.DatabaseNotExistException(name);
            }
        }
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        return new ArrayList<String>();
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createPartition(Identifier identifier, Map<String, String> partitionSpec) throws Catalog.TableNotExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropPartition(Identifier identifier, Map<String, String> partitions) throws Catalog.TableNotExistException, Catalog.PartitionNotExistException {
    }

    @Override
    public List<Partition> listPartitions(Identifier identifier) throws Catalog.TableNotExistException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean caseSensitive() {
        return this.options.getOptional(CatalogOptions.CASE_SENSITIVE).orElse(true);
    }

    @Override
    public void close() throws Exception {
        if (this.refreshExecutor != null) {
            this.refreshExecutor.shutdownNow();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    @VisibleForTesting
    Map<String, String> fetchOptionsFromServer(Map<String, String> headers, Map<String, String> clientProperties) {
        ConfigResponse response = this.client.get("/v1/config", ConfigResponse.class, headers);
        return response.merge(clientProperties);
    }

    private static Map<String, String> configHeaders(Map<String, String> properties) {
        return RESTUtil.extractPrefixMap(properties, "header.");
    }

    private Map<String, String> headers() {
        return this.catalogAuth.getHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService tokenRefreshExecutor() {
        if (this.refreshExecutor == null) {
            RESTCatalog rESTCatalog = this;
            synchronized (rESTCatalog) {
                if (this.refreshExecutor == null) {
                    this.refreshExecutor = ThreadPoolUtils.createScheduledThreadPool(1, "token-refresh-thread");
                }
            }
        }
        return this.refreshExecutor;
    }
}

