/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogInternalOptions;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.auth.CredentialsProvider;
import org.apache.paimon.rest.auth.CredentialsProviderType;

public interface CredentialsProviderFactory
extends Factory {
    default public CredentialsProvider create(Options options) {
        throw new UnsupportedOperationException("Use  create(context) for " + this.getClass().getSimpleName());
    }

    public static CredentialsProvider createCredentialsProvider(Options options, ClassLoader classLoader) {
        String credentialsProviderIdentifier = CredentialsProviderFactory.getCredentialsProviderTypeByConf(options).name();
        CredentialsProviderFactory credentialsProviderFactory = FactoryUtil.discoverFactory(classLoader, CredentialsProviderFactory.class, credentialsProviderIdentifier);
        return credentialsProviderFactory.create(options);
    }

    public static CredentialsProviderType getCredentialsProviderTypeByConf(Options options) {
        if (options.getOptional(RESTCatalogInternalOptions.CREDENTIALS_PROVIDER).isPresent()) {
            return CredentialsProviderType.valueOf(options.get(RESTCatalogInternalOptions.CREDENTIALS_PROVIDER));
        }
        if (options.getOptional(RESTCatalogOptions.TOKEN_PROVIDER_PATH).isPresent()) {
            return CredentialsProviderType.BEAR_TOKEN_FILE;
        }
        return CredentialsProviderType.BEAR_TOKEN;
    }
}

