/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaMergingUtils;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.base.Joiner;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterables;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@ThreadSafe
public class SchemaManager
implements Serializable {
    private static final String SCHEMA_PREFIX = "schema-";
    private final FileIO fileIO;
    private final Path tableRoot;
    @Nullable
    private transient Lock lock;
    private final String branch;

    public SchemaManager(FileIO fileIO, Path tableRoot) {
        this(fileIO, tableRoot, "main");
    }

    public SchemaManager(FileIO fileIO, Path tableRoot, String branch) {
        this.fileIO = fileIO;
        this.tableRoot = tableRoot;
        this.branch = BranchManager.normalizeBranch(branch);
    }

    public SchemaManager copyWithBranch(String branchName) {
        return new SchemaManager(this.fileIO, this.tableRoot, branchName);
    }

    public SchemaManager withLock(@Nullable Lock lock) {
        this.lock = lock;
        return this;
    }

    public Optional<TableSchema> latest() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::max).map(this::schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long earliestCreationTime() {
        try {
            long earliest = 0L;
            if (!this.schemaExists(0L)) {
                Optional<Long> min = FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::min);
                Preconditions.checkArgument(min.isPresent());
                earliest = min.get();
            }
            Path schemaPath = this.toSchemaPath(earliest);
            return this.fileIO.getFileStatus(schemaPath).getModificationTime();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<TableSchema> listAll() {
        return this.listAllIds().stream().map(this::schema).collect(Collectors.toList());
    }

    public List<TableSchema> schemasWithId(List<Long> schemaIds) {
        return schemaIds.stream().map(this::schema).collect(Collectors.toList());
    }

    public List<TableSchema> listWithRange(Optional<Long> optionalMaxSchemaId, Optional<Long> optionalMinSchemaId) {
        Long lowerBoundSchemaId = 0L;
        Long upperBoundSchematId = this.latest().get().id();
        if (!optionalMaxSchemaId.isPresent() && !optionalMinSchemaId.isPresent()) {
            return this.listAll();
        }
        if (optionalMaxSchemaId.isPresent()) {
            if (optionalMaxSchemaId.get() < lowerBoundSchemaId) {
                throw new RuntimeException(String.format("schema id: %s should not lower than min schema id: %s", optionalMaxSchemaId.get(), lowerBoundSchemaId));
            }
            Long l = upperBoundSchematId = optionalMaxSchemaId.get() > upperBoundSchematId ? upperBoundSchematId : optionalMaxSchemaId.get();
        }
        if (optionalMinSchemaId.isPresent()) {
            if (optionalMinSchemaId.get() > upperBoundSchematId) {
                throw new RuntimeException(String.format("schema id: %s should not greater than max schema id: %s", optionalMinSchemaId.get(), upperBoundSchematId));
            }
            lowerBoundSchemaId = optionalMinSchemaId.get() > lowerBoundSchemaId ? optionalMinSchemaId.get() : lowerBoundSchemaId;
        }
        return LongStream.range(lowerBoundSchemaId, upperBoundSchematId + 1L).mapToObj(this::schema).sorted(Comparator.comparingLong(TableSchema::id)).collect(Collectors.toList());
    }

    public List<Long> listAllIds() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TableSchema createTable(Schema schema) throws Exception {
        return this.createTable(schema, false);
    }

    public TableSchema createTable(Schema schema, boolean externalTable) throws Exception {
        TableSchema newSchema;
        boolean success;
        do {
            Optional<TableSchema> latest;
            if ((latest = this.latest()).isPresent()) {
                TableSchema latestSchema = latest.get();
                if (externalTable) {
                    this.checkSchemaForExternalTable(latestSchema.toSchema(), schema);
                    return latestSchema;
                }
                throw new IllegalStateException("Schema in filesystem exists, creation is not allowed.");
            }
            List<DataField> fields = schema.fields();
            List<String> partitionKeys = schema.partitionKeys();
            List<String> primaryKeys = schema.primaryKeys();
            Map<String, String> options = schema.options();
            int highestFieldId = RowType.currentHighestFieldId(fields);
            newSchema = new TableSchema(0L, fields, highestFieldId, partitionKeys, primaryKeys, options, schema.comment());
            FileStoreTableFactory.create(this.fileIO, this.tableRoot, newSchema).store();
        } while (!(success = this.commit(newSchema)));
        return newSchema;
    }

    private void checkSchemaForExternalTable(Schema existsSchema, Schema newSchema) {
        if (!newSchema.fields().isEmpty() && !newSchema.rowType().equalsIgnoreFieldId(existsSchema.rowType()) || !newSchema.partitionKeys().isEmpty() && !Objects.equals(newSchema.partitionKeys(), existsSchema.partitionKeys()) || !newSchema.primaryKeys().isEmpty() && !Objects.equals(newSchema.primaryKeys(), existsSchema.primaryKeys())) {
            throw new RuntimeException("New schema is not equal to exists schema, new schema: " + newSchema + ", exists schema: " + existsSchema);
        }
        Map<String, String> existsOptions = existsSchema.options();
        Map<String, String> newOptions = newSchema.options();
        newOptions.forEach((key, value) -> {
            if (!(key.equals("owner") || key.equals(CoreOptions.PATH.key()) || existsOptions.containsKey(key) && ((String)existsOptions.get(key)).equals(value))) {
                throw new RuntimeException("New schema's options are not equal to the exists schema's, new schema: " + newOptions + ", exists schema: " + existsOptions);
            }
        });
    }

    public TableSchema commitChanges(SchemaChange ... changes) throws Exception {
        return this.commitChanges(Arrays.asList(changes));
    }

    /*
     * Exception decompiling
     */
    public TableSchema commitChanges(List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void applyMove(List<DataField> newFields, SchemaChange.Move move) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < newFields.size(); ++i) {
            map.put(newFields.get(i).name(), i);
        }
        int fieldIndex = map.getOrDefault(move.fieldName(), -1);
        if (fieldIndex == -1) {
            throw new IllegalArgumentException("Field name not found: " + move.fieldName());
        }
        switch (move.type()) {
            case FIRST: {
                SchemaManager.checkMoveIndexEqual(move, fieldIndex, 0);
                this.moveField(newFields, fieldIndex, 0);
                return;
            }
            case LAST: {
                SchemaManager.checkMoveIndexEqual(move, fieldIndex, newFields.size() - 1);
                this.moveField(newFields, fieldIndex, newFields.size() - 1);
                return;
            }
        }
        Integer refIndex = map.getOrDefault(move.referenceFieldName(), -1);
        if (refIndex == -1) {
            throw new IllegalArgumentException("Reference field name not found: " + move.referenceFieldName());
        }
        SchemaManager.checkMoveIndexEqual(move, fieldIndex, refIndex);
        int targetIndex = refIndex;
        if (move.type() == SchemaChange.Move.MoveType.AFTER && fieldIndex > refIndex) {
            ++targetIndex;
        }
        if (move.type() == SchemaChange.Move.MoveType.BEFORE && fieldIndex < refIndex) {
            --targetIndex;
        }
        if (targetIndex > newFields.size() - 1) {
            targetIndex = newFields.size() - 1;
        }
        this.moveField(newFields, fieldIndex, targetIndex);
    }

    private void moveField(List<DataField> newFields, int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= newFields.size() || toIndex < 0) {
            return;
        }
        DataField fieldToMove = newFields.remove(fromIndex);
        newFields.add(toIndex, fieldToMove);
    }

    private static void checkMoveIndexEqual(SchemaChange.Move move, int fieldIndex, int refIndex) {
        if (refIndex == fieldIndex) {
            throw new UnsupportedOperationException(String.format("Cannot move itself for column %s", move.fieldName()));
        }
    }

    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        TableSchema update;
        TableSchema current = this.latest().orElseThrow(() -> new RuntimeException("It requires that the current schema to exist when calling 'mergeSchema'"));
        if (current.equals(update = SchemaMergingUtils.mergeSchemas(current, rowType, allowExplicitCast))) {
            return false;
        }
        try {
            return this.commit(update);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit the schema.", e);
        }
    }

    private static Map<String, String> applySchemaChanges(Map<String, String> options, Iterable<SchemaChange> changes) {
        HashMap<String, String> newOptions = Maps.newHashMap(options);
        String bucketKeysStr = options.get(CoreOptions.BUCKET_KEY.key());
        if (!StringUtils.isNullOrWhitespaceOnly(bucketKeysStr)) {
            List<String> bucketColumns = Arrays.asList(bucketKeysStr.split(","));
            List<String> newBucketColumns = SchemaManager.applyNotNestedColumnRename(bucketColumns, Iterables.filter(changes, SchemaChange.RenameColumn.class));
            newOptions.put(CoreOptions.BUCKET_KEY.key(), Joiner.on(',').join(newBucketColumns));
        }
        return newOptions;
    }

    private static List<String> applyNotNestedColumnRename(List<String> columns, Iterable<SchemaChange.RenameColumn> renames) {
        if (Iterables.isEmpty(renames)) {
            return columns;
        }
        HashMap<String, String> columnNames = Maps.newHashMap();
        for (SchemaChange.RenameColumn renameColumn : renames) {
            if (renameColumn.fieldNames().length != 1) continue;
            columnNames.put(renameColumn.fieldNames()[0], renameColumn.newName());
        }
        return columns.stream().map(column -> columnNames.getOrDefault(column, (String)column)).collect(Collectors.toList());
    }

    private static void dropColumnValidation(TableSchema schema, SchemaChange.DropColumn change) {
        if (change.fieldNames().length > 1) {
            return;
        }
        String columnToDrop = change.fieldNames()[0];
        if (schema.partitionKeys().contains(columnToDrop) || schema.primaryKeys().contains(columnToDrop)) {
            throw new UnsupportedOperationException(String.format("Cannot drop partition key or primary key: [%s]", columnToDrop));
        }
    }

    private static void assertNotUpdatingPrimaryKeys(TableSchema schema, String[] fieldNames, String operation) {
        if (fieldNames.length > 1) {
            return;
        }
        String columnToRename = fieldNames[0];
        if (schema.partitionKeys().contains(columnToRename)) {
            throw new UnsupportedOperationException(String.format("Cannot " + operation + " partition column: [%s]", columnToRename));
        }
    }

    private void updateNestedColumn(List<DataField> newFields, final String[] updateFieldNames, final Function<DataField, DataField> updateFunc) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException {
        new NestedColumnModifier(updateFieldNames){

            @Override
            protected void updateLastColumn(List<DataField> newFields, String fieldName) throws Catalog.ColumnNotExistException {
                for (int i = 0; i < newFields.size(); ++i) {
                    DataField field = newFields.get(i);
                    if (!field.name().equals(fieldName)) continue;
                    newFields.set(i, (DataField)updateFunc.apply(field));
                    return;
                }
                throw new Catalog.ColumnNotExistException(SchemaManager.identifierFromPath(SchemaManager.this.tableRoot.toString(), true, SchemaManager.this.branch), String.join((CharSequence)".", updateFieldNames));
            }
        }.updateIntermediateColumn(newFields, 0);
    }

    @VisibleForTesting
    boolean commit(TableSchema newSchema) throws Exception {
        SchemaValidation.validateTableSchema(newSchema);
        SchemaValidation.validateFallbackBranch(this, newSchema);
        Path schemaPath = this.toSchemaPath(newSchema.id());
        Callable<Boolean> callable = () -> this.fileIO.tryToWriteAtomic(schemaPath, newSchema.toString());
        if (this.lock == null) {
            return callable.call();
        }
        return this.lock.runWithLock(callable);
    }

    public TableSchema schema(long id) {
        return TableSchema.fromPath(this.fileIO, this.toSchemaPath(id));
    }

    public boolean schemaExists(long id) {
        Path path = this.toSchemaPath(id);
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if schema '%s' exists in path %s.", id, path), e);
        }
    }

    private String branchPath() {
        return BranchManager.branchPath(this.tableRoot, this.branch);
    }

    public Path schemaDirectory() {
        return new Path(this.branchPath() + "/schema");
    }

    @VisibleForTesting
    public Path toSchemaPath(long schemaId) {
        return new Path(this.branchPath() + "/schema/" + SCHEMA_PREFIX + schemaId);
    }

    public List<Path> schemaPaths(Predicate<Long> predicate) throws IOException {
        return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).filter(predicate).map(this::toSchemaPath).collect(Collectors.toList());
    }

    public void deleteSchema(long schemaId) {
        this.fileIO.deleteQuietly(this.toSchemaPath(schemaId));
    }

    public static void checkAlterTableOption(String key, @Nullable String oldValue, String newValue, boolean fromDynamicOptions) {
        if (CoreOptions.IMMUTABLE_OPTIONS.contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
        if (CoreOptions.BUCKET.key().equals(key)) {
            int oldBucket = oldValue == null ? CoreOptions.BUCKET.defaultValue() : Integer.parseInt(oldValue);
            int newBucket = Integer.parseInt(newValue);
            if (fromDynamicOptions) {
                throw new UnsupportedOperationException("Cannot change bucket number through dynamic options. You might need to rescale bucket.");
            }
            if (oldBucket == -1) {
                throw new UnsupportedOperationException("Cannot change bucket when it is -1.");
            }
            if (newBucket == -1) {
                throw new UnsupportedOperationException("Cannot change bucket to -1.");
            }
        }
    }

    public static void checkResetTableOption(String key) {
        if (CoreOptions.IMMUTABLE_OPTIONS.contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
        if (CoreOptions.BUCKET.key().equals(key)) {
            throw new UnsupportedOperationException(String.format("Cannot reset %s.", key));
        }
    }

    public static void checkAlterTablePath(String key) {
        if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
            throw new UnsupportedOperationException("Change path is not supported yet.");
        }
    }

    public static Identifier identifierFromPath(String tablePath, boolean ignoreIfUnknownDatabase) {
        return SchemaManager.identifierFromPath(tablePath, ignoreIfUnknownDatabase, null);
    }

    public static Identifier identifierFromPath(String tablePath, boolean ignoreIfUnknownDatabase, @Nullable String branchName) {
        String[] paths;
        if ("main".equals(branchName)) {
            branchName = null;
        }
        if ((paths = tablePath.split("/")).length < 2) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a valid path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[0]);
        }
        String database = paths[paths.length - 2];
        int index = database.lastIndexOf(".db");
        if (index == -1) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a valid path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[paths.length - 1], branchName, null);
        }
        database = database.substring(0, index);
        return new Identifier(database, paths[paths.length - 1], branchName, null);
    }

    private static /* synthetic */ DataField lambda$commitChanges$4(SchemaChange.UpdateColumnComment update, DataField field) {
        return new DataField(field.id(), field.name(), field.type(), update.newDescription());
    }

    private static /* synthetic */ DataField lambda$commitChanges$3(SchemaChange.UpdateColumnNullability update, DataField field) {
        return new DataField(field.id(), field.name(), field.type().copy(update.newNullability()), field.description());
    }

    private static /* synthetic */ DataField lambda$commitChanges$2(SchemaChange.UpdateColumnType update, DataField field) {
        DataType targetType = update.newDataType();
        if (update.keepNullability()) {
            targetType = targetType.copy(field.type().isNullable());
        }
        Preconditions.checkState(DataTypeCasts.supportsExplicitCast(field.type(), targetType) && CastExecutors.resolve(field.type(), targetType) != null, String.format("Column type %s[%s] cannot be converted to %s without loosing information.", field.name(), field.type(), targetType));
        return new DataField(field.id(), field.name(), targetType, field.description());
    }

    private /* synthetic */ Catalog.TableNotExistException lambda$commitChanges$1() {
        return new Catalog.TableNotExistException(SchemaManager.identifierFromPath(this.tableRoot.toString(), true, this.branch));
    }

    private abstract class NestedColumnModifier {
        private final String[] updateFieldNames;

        private NestedColumnModifier(String[] updateFieldNames) {
            this.updateFieldNames = updateFieldNames;
        }

        public void updateIntermediateColumn(List<DataField> newFields, int depth) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException {
            if (depth == this.updateFieldNames.length - 1) {
                this.updateLastColumn(newFields, this.updateFieldNames[depth]);
                return;
            }
            for (int i = 0; i < newFields.size(); ++i) {
                DataField field = newFields.get(i);
                if (!field.name().equals(this.updateFieldNames[depth])) continue;
                String fullFieldName = String.join((CharSequence)".", Arrays.asList(this.updateFieldNames).subList(0, depth + 1));
                ArrayList<DataField> nestedFields = new ArrayList<DataField>();
                int newDepth = depth + this.extractRowDataFields(field.type(), fullFieldName, nestedFields);
                this.updateIntermediateColumn(nestedFields, newDepth);
                newFields.set(i, new DataField(field.id(), field.name(), this.wrapNewRowType(field.type(), nestedFields), field.description()));
                return;
            }
            throw new Catalog.ColumnNotExistException(SchemaManager.identifierFromPath(SchemaManager.this.tableRoot.toString(), true, SchemaManager.this.branch), String.join((CharSequence)".", Arrays.asList(this.updateFieldNames).subList(0, depth + 1)));
        }

        private int extractRowDataFields(DataType type, String fullFieldName, List<DataField> nestedFields) {
            switch (type.getTypeRoot()) {
                case ROW: {
                    nestedFields.addAll(((RowType)type).getFields());
                    return 1;
                }
                case ARRAY: {
                    return this.extractRowDataFields(((ArrayType)type).getElementType(), fullFieldName, nestedFields) + 1;
                }
                case MAP: {
                    return this.extractRowDataFields(((MapType)type).getValueType(), fullFieldName, nestedFields) + 1;
                }
            }
            throw new IllegalArgumentException(fullFieldName + " is not a structured type.");
        }

        private DataType wrapNewRowType(DataType type, List<DataField> nestedFields) {
            switch (type.getTypeRoot()) {
                case ROW: {
                    return new RowType(type.isNullable(), nestedFields);
                }
                case ARRAY: {
                    return new ArrayType(type.isNullable(), this.wrapNewRowType(((ArrayType)type).getElementType(), nestedFields));
                }
                case MAP: {
                    MapType mapType = (MapType)type;
                    return new MapType(type.isNullable(), mapType.getKeyType(), this.wrapNewRowType(mapType.getValueType(), nestedFields));
                }
            }
            throw new IllegalStateException("Trying to wrap a row type in " + type + ". This is unexpected.");
        }

        protected abstract void updateLastColumn(List<DataField> var1, String var2) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException;

        protected void assertColumnExists(List<DataField> newFields, String fieldName) throws Catalog.ColumnNotExistException {
            for (DataField field : newFields) {
                if (!field.name().equals(fieldName)) continue;
                return;
            }
            throw new Catalog.ColumnNotExistException(SchemaManager.identifierFromPath(SchemaManager.this.tableRoot.toString(), true, SchemaManager.this.branch), this.getLastFieldName(fieldName));
        }

        protected void assertColumnNotExists(List<DataField> newFields, String fieldName) throws Catalog.ColumnAlreadyExistException {
            for (DataField field : newFields) {
                if (!field.name().equals(fieldName)) continue;
                throw new Catalog.ColumnAlreadyExistException(SchemaManager.identifierFromPath(SchemaManager.this.tableRoot.toString(), true, SchemaManager.this.branch), this.getLastFieldName(fieldName));
            }
        }

        private String getLastFieldName(String fieldName) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            int i = 0;
            while (i + 1 < this.updateFieldNames.length) {
                fieldNames.add(this.updateFieldNames[i]);
                ++i;
            }
            fieldNames.add(fieldName);
            return String.join((CharSequence)".", fieldNames);
        }
    }
}

