/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.operation.ChangelogDeletion;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RollbackHelper.class);
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final FileIO fileIO;
    private final SnapshotDeletion snapshotDeletion;
    private final ChangelogDeletion changelogDeletion;
    private final TagDeletion tagDeletion;

    public RollbackHelper(SnapshotManager snapshotManager, TagManager tagManager, FileIO fileIO, SnapshotDeletion snapshotDeletion, ChangelogDeletion changelogDeletion, TagDeletion tagDeletion) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.fileIO = fileIO;
        this.snapshotDeletion = snapshotDeletion;
        this.changelogDeletion = changelogDeletion;
        this.tagDeletion = tagDeletion;
    }

    public void cleanLargerThan(Snapshot retainedSnapshot) {
        List<Snapshot> cleanedSnapshots = this.cleanSnapshotsDataFiles(retainedSnapshot);
        List<Changelog> cleanedChangelogs = this.cleanLongLivedChangelogDataFiles(retainedSnapshot);
        List<Snapshot> cleanedTags = this.cleanTagsDataFiles(retainedSnapshot);
        HashSet<Long> cleanedIds = new HashSet<Long>();
        Set<String> manifestsSkippingSet = this.snapshotDeletion.manifestSkippingSet(retainedSnapshot);
        for (Snapshot snapshot : cleanedSnapshots) {
            this.snapshotDeletion.cleanUnusedManifests(snapshot, manifestsSkippingSet);
            cleanedIds.add(snapshot.id());
        }
        for (Changelog changelog : cleanedChangelogs) {
            this.changelogDeletion.cleanUnusedManifests(changelog, manifestsSkippingSet);
            cleanedIds.add(changelog.id());
        }
        for (Snapshot snapshot : cleanedTags) {
            if (cleanedIds.contains(snapshot.id())) continue;
            this.tagDeletion.cleanUnusedManifests(snapshot, manifestsSkippingSet);
        }
    }

    private List<Snapshot> cleanSnapshotsDataFiles(Snapshot retainedSnapshot) {
        long earliest = Preconditions.checkNotNull(this.snapshotManager.earliestSnapshotId(), "Cannot find earliest snapshot.");
        long latest = Preconditions.checkNotNull(this.snapshotManager.latestSnapshotId(), "Cannot find latest snapshot.");
        try {
            this.snapshotManager.commitLatestHint(retainedSnapshot.id());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ArrayList<Snapshot> toBeCleaned = new ArrayList<Snapshot>();
        long to = Math.max(earliest, retainedSnapshot.id() + 1L);
        for (long i = latest; i >= to; --i) {
            if (!this.snapshotManager.snapshotExists(i)) continue;
            toBeCleaned.add(this.snapshotManager.snapshot(i));
            this.snapshotManager.deleteSnapshot(i);
        }
        for (Snapshot snapshot : toBeCleaned) {
            this.snapshotDeletion.deleteAddedDataFiles(snapshot.deltaManifestList());
            if (snapshot.changelogManifestList() == null) continue;
            this.snapshotDeletion.deleteAddedDataFiles(snapshot.changelogManifestList());
        }
        this.snapshotDeletion.cleanEmptyDirectories();
        return toBeCleaned;
    }

    private List<Changelog> cleanLongLivedChangelogDataFiles(Snapshot retainedSnapshot) {
        Long earliest = this.snapshotManager.earliestLongLivedChangelogId();
        Long latest = this.snapshotManager.latestLongLivedChangelogId();
        if (earliest == null || latest == null) {
            return Collections.emptyList();
        }
        ArrayList<Changelog> toBeCleaned = new ArrayList<Changelog>();
        long to = Math.max(earliest, retainedSnapshot.id() + 1L);
        for (long i = latest.longValue(); i >= to; --i) {
            toBeCleaned.add(this.snapshotManager.changelog(i));
        }
        try {
            if (toBeCleaned.size() > 0) {
                if (to == earliest) {
                    this.snapshotManager.commitLongLivedChangelogLatestHint(-1L);
                } else {
                    this.snapshotManager.commitLongLivedChangelogLatestHint(to - 1L);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (Changelog changelog : toBeCleaned) {
            this.fileIO.deleteQuietly(this.snapshotManager.longLivedChangelogPath(changelog.id()));
            this.changelogDeletion.cleanUnusedDataFiles(changelog, manifestEntry -> false);
        }
        this.snapshotDeletion.cleanEmptyDirectories();
        return toBeCleaned;
    }

    private List<Snapshot> cleanTagsDataFiles(Snapshot retainedSnapshot) {
        Snapshot tag;
        SortedMap<Snapshot, List<String>> tags = this.tagManager.tags();
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Snapshot> taggedSnapshots = new ArrayList<Snapshot>(tags.keySet());
        ArrayList<Snapshot> toBeCleaned = new ArrayList<Snapshot>();
        for (int i = taggedSnapshots.size() - 1; i >= 0 && (tag = (Snapshot)taggedSnapshots.get(i)).id() > retainedSnapshot.id(); --i) {
            toBeCleaned.add(tag);
            ((List)tags.get(tag)).forEach(tagName -> this.fileIO.deleteQuietly(this.tagManager.tagPath((String)tagName)));
        }
        Predicate<ExpireFileEntry> dataFileSkipper = null;
        boolean success = true;
        try {
            dataFileSkipper = this.tagDeletion.dataFileSkipper(retainedSnapshot);
        }
        catch (Exception e) {
            LOG.info("Skip cleaning data files for deleted tags due to failed to build skipping set.", (Throwable)e);
            success = false;
        }
        if (success) {
            for (Snapshot s : toBeCleaned) {
                this.tagDeletion.cleanUnusedDataFiles(s, dataFileSkipper);
            }
            this.tagDeletion.cleanEmptyDirectories();
        }
        return toBeCleaned;
    }
}

