/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.And;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.GreaterOrEqual;
import org.apache.paimon.predicate.GreaterThan;
import org.apache.paimon.predicate.InPredicateVisitor;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafPredicateExtractor;
import org.apache.paimon.predicate.LessOrEqual;
import org.apache.paimon.predicate.LessThan;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class SchemasTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMAS = "schemas";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "schema_id", new BigIntType(false)), new DataField(1, "fields", SerializationUtils.newStringType(false)), new DataField(2, "partition_keys", SerializationUtils.newStringType(false)), new DataField(3, "primary_keys", SerializationUtils.newStringType(false)), new DataField(4, "options", SerializationUtils.newStringType(false)), new DataField(5, "comment", SerializationUtils.newStringType(true)), new DataField(6, "update_time", new TimestampType(false, 3))));
    private final Path location;
    private final FileStoreTable dataTable;

    public SchemasTable(FileStoreTable dataTable) {
        this.location = dataTable.location();
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + SCHEMAS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("schema_id");
    }

    @Override
    public InnerTableScan newScan() {
        return new SchemasScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new SchemasRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new SchemasTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private class SchemasRead
    implements InnerTableRead {
        private RowType readType;
        private Optional<Long> optionalFilterSchemaIdMax = Optional.empty();
        private Optional<Long> optionalFilterSchemaIdMin = Optional.empty();
        private final List<Long> schemaIds = new ArrayList<Long>();

        private SchemasRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            if (predicate == null) {
                return this;
            }
            String leafName = "schema_id";
            if (predicate instanceof CompoundPredicate) {
                CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
                if (compoundPredicate.function() instanceof And) {
                    List<Predicate> children = compoundPredicate.children();
                    for (Predicate leaf : children) {
                        this.handleLeafPredicate(leaf, leafName);
                    }
                }
                if (compoundPredicate.function() instanceof Or) {
                    InPredicateVisitor.extractInElements(predicate, leafName).ifPresent(leafs -> leafs.forEach(leaf -> this.schemaIds.add(Long.parseLong(leaf.toString()))));
                }
            } else {
                this.handleLeafPredicate(predicate, leafName);
            }
            return this;
        }

        public void handleLeafPredicate(Predicate predicate, String leafName) {
            LeafPredicate snapshotPred = predicate.visit(LeafPredicateExtractor.INSTANCE).get(leafName);
            if (snapshotPred != null) {
                if (snapshotPred.function() instanceof Equal) {
                    this.optionalFilterSchemaIdMin = Optional.of((Long)snapshotPred.literals().get(0));
                    this.optionalFilterSchemaIdMax = Optional.of((Long)snapshotPred.literals().get(0));
                }
                if (snapshotPred.function() instanceof GreaterThan) {
                    this.optionalFilterSchemaIdMin = Optional.of((Long)snapshotPred.literals().get(0) + 1L);
                }
                if (snapshotPred.function() instanceof GreaterOrEqual) {
                    this.optionalFilterSchemaIdMin = Optional.of((Long)snapshotPred.literals().get(0));
                }
                if (snapshotPred.function() instanceof LessThan) {
                    this.optionalFilterSchemaIdMax = Optional.of((Long)snapshotPred.literals().get(0) - 1L);
                }
                if (snapshotPred.function() instanceof LessOrEqual) {
                    this.optionalFilterSchemaIdMax = Optional.of((Long)snapshotPred.literals().get(0));
                }
            }
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof SchemasSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            SchemaManager manager = SchemasTable.this.dataTable.schemaManager();
            List<TableSchema> tableSchemas = !this.schemaIds.isEmpty() ? manager.schemasWithId(this.schemaIds) : manager.listWithRange(this.optionalFilterSchemaIdMax, this.optionalFilterSchemaIdMin);
            Iterator rows = Iterators.transform(tableSchemas.iterator(), this::toRow);
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(TableSchema schema) {
            return GenericRow.of(schema.id(), this.toJson(schema.fields()), this.toJson(schema.partitionKeys()), this.toJson(schema.primaryKeys()), this.toJson(schema.options()), BinaryString.fromString(schema.comment()), Timestamp.fromLocalDateTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(schema.timeMillis()), ZoneId.systemDefault())));
        }

        private BinaryString toJson(Object obj) {
            return BinaryString.fromString(JsonSerdeUtil.toFlatJson(obj));
        }
    }

    private static class SchemasSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;

        private SchemasSplit() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class SchemasScan
    extends ReadOnceTableScan {
        private SchemasScan() {
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new SchemasSplit());
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }
    }
}

