/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;

@ThreadSafe
public class FileStorePathFactory {
    public static final String MANIFEST_PATH = "manifest";
    public static final String MANIFEST_PREFIX = "manifest-";
    public static final String MANIFEST_LIST_PREFIX = "manifest-list-";
    public static final String INDEX_MANIFEST_PREFIX = "index-manifest-";
    public static final String INDEX_PATH = "index";
    public static final String INDEX_PREFIX = "index-";
    public static final String STATISTICS_PATH = "statistics";
    public static final String STATISTICS_PREFIX = "stat-";
    public static final String BUCKET_PATH_PREFIX = "bucket-";
    private final Path root;
    private final String uuid;
    private final InternalRowPartitionComputer partitionComputer;
    private final String formatIdentifier;
    private final String dataFilePrefix;
    private final String changelogFilePrefix;
    private final boolean fileSuffixIncludeCompression;
    private final String fileCompression;
    @Nullable
    private final String dataFilePathDirectory;
    private final AtomicInteger manifestFileCount;
    private final AtomicInteger manifestListCount;
    private final AtomicInteger indexManifestCount;
    private final AtomicInteger indexFileCount;
    private final AtomicInteger statsFileCount;

    public FileStorePathFactory(Path root, RowType partitionType, String defaultPartValue, String formatIdentifier, String dataFilePrefix, String changelogFilePrefix, boolean legacyPartitionName, boolean fileSuffixIncludeCompression, String fileCompression, @Nullable String dataFilePathDirectory) {
        this.root = root;
        this.dataFilePathDirectory = dataFilePathDirectory;
        this.uuid = UUID.randomUUID().toString();
        this.partitionComputer = FileStorePathFactory.getPartitionComputer(partitionType, defaultPartValue, legacyPartitionName);
        this.formatIdentifier = formatIdentifier;
        this.dataFilePrefix = dataFilePrefix;
        this.changelogFilePrefix = changelogFilePrefix;
        this.fileSuffixIncludeCompression = fileSuffixIncludeCompression;
        this.fileCompression = fileCompression;
        this.manifestFileCount = new AtomicInteger(0);
        this.manifestListCount = new AtomicInteger(0);
        this.indexManifestCount = new AtomicInteger(0);
        this.indexFileCount = new AtomicInteger(0);
        this.statsFileCount = new AtomicInteger(0);
    }

    public Path root() {
        return this.root;
    }

    public Path manifestPath() {
        return new Path(this.root, MANIFEST_PATH);
    }

    public Path indexPath() {
        return new Path(this.root, INDEX_PATH);
    }

    public Path statisticsPath() {
        return new Path(this.root, STATISTICS_PATH);
    }

    public Path dataFilePath() {
        if (this.dataFilePathDirectory != null) {
            return new Path(this.root, this.dataFilePathDirectory);
        }
        return this.root;
    }

    @VisibleForTesting
    public static InternalRowPartitionComputer getPartitionComputer(RowType partitionType, String defaultPartValue, boolean legacyPartitionName) {
        String[] partitionColumns = partitionType.getFieldNames().toArray(new String[0]);
        return new InternalRowPartitionComputer(defaultPartValue, partitionType, partitionColumns, legacyPartitionName);
    }

    public Path newManifestFile() {
        return this.toManifestFilePath(MANIFEST_PREFIX + this.uuid + "-" + this.manifestFileCount.getAndIncrement());
    }

    public Path newManifestList() {
        return this.toManifestListPath(MANIFEST_LIST_PREFIX + this.uuid + "-" + this.manifestListCount.getAndIncrement());
    }

    public Path toManifestFilePath(String manifestFileName) {
        return new Path(this.manifestPath(), manifestFileName);
    }

    public Path toManifestListPath(String manifestListName) {
        return new Path(this.manifestPath(), manifestListName);
    }

    public DataFilePathFactory createDataFilePathFactory(BinaryRow partition, int bucket) {
        return new DataFilePathFactory(this.bucketPath(partition, bucket), this.formatIdentifier, this.dataFilePrefix, this.changelogFilePrefix, this.fileSuffixIncludeCompression, this.fileCompression);
    }

    public Path bucketPath(BinaryRow partition, int bucket) {
        return new Path(this.root, this.relativeBucketPath(partition, bucket));
    }

    public Path relativeBucketPath(BinaryRow partition, int bucket) {
        Path relativeBucketPath = new Path(BUCKET_PATH_PREFIX + bucket);
        String partitionPath = this.getPartitionString(partition);
        if (!partitionPath.isEmpty()) {
            relativeBucketPath = new Path(partitionPath, relativeBucketPath);
        }
        if (this.dataFilePathDirectory != null) {
            relativeBucketPath = new Path(this.dataFilePathDirectory, relativeBucketPath);
        }
        return relativeBucketPath;
    }

    public String getPartitionString(BinaryRow partition) {
        return PartitionPathUtils.generatePartitionPath(this.partitionComputer.generatePartValues(Preconditions.checkNotNull(partition, "Partition row data is null. This is unexpected.")));
    }

    public List<Path> getHierarchicalPartitionPath(BinaryRow partition) {
        return PartitionPathUtils.generateHierarchicalPartitionPaths(this.partitionComputer.generatePartValues(Preconditions.checkNotNull(partition, "Partition binary row is null. This is unexpected."))).stream().map(p -> new Path(this.root + "/" + p)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public String uuid() {
        return this.uuid;
    }

    public PathFactory manifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return FileStorePathFactory.this.newManifestFile();
            }

            @Override
            public Path toPath(String fileName) {
                return FileStorePathFactory.this.toManifestFilePath(fileName);
            }
        };
    }

    public PathFactory manifestListFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return FileStorePathFactory.this.newManifestList();
            }

            @Override
            public Path toPath(String fileName) {
                return FileStorePathFactory.this.toManifestListPath(fileName);
            }
        };
    }

    public PathFactory indexManifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return this.toPath(FileStorePathFactory.INDEX_MANIFEST_PREFIX + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.indexManifestCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.manifestPath(), fileName);
            }
        };
    }

    public PathFactory indexFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return this.toPath(FileStorePathFactory.INDEX_PREFIX + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.indexFileCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.indexPath(), fileName);
            }
        };
    }

    public PathFactory statsFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return this.toPath(FileStorePathFactory.STATISTICS_PREFIX + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.statsFileCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.statisticsPath(), fileName);
            }
        };
    }
}

