/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.regex.Pattern;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.StringUtils;

public class ClearConsumersProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "clear_consumers";

    public String[] call(ProcedureContext procedureContext, String tableId, String includingConsumers, String excludingConsumers) throws Catalog.TableNotExistException {
        FileStoreTable fileStoreTable = (FileStoreTable)this.catalog.getTable(Identifier.fromString(tableId));
        ConsumerManager consumerManager = new ConsumerManager(fileStoreTable.fileIO(), fileStoreTable.location(), fileStoreTable.snapshotManager().branch());
        Pattern includingPattern = StringUtils.isNullOrWhitespaceOnly(includingConsumers) ? Pattern.compile(".*") : Pattern.compile(includingConsumers);
        Pattern excludingPattern = StringUtils.isNullOrWhitespaceOnly(excludingConsumers) ? null : Pattern.compile(excludingConsumers);
        consumerManager.clearConsumers(includingPattern, excludingPattern);
        return new String[]{"Success"};
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String includingConsumers) throws Catalog.TableNotExistException {
        return this.call(procedureContext, tableId, includingConsumers, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId) throws Catalog.TableNotExistException {
        return this.call(procedureContext, tableId, null, null);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

