/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.TimeUtils;

public abstract class CreateOrReplaceTagBaseProcedure
extends ProcedureBase {
    public String[] call(ProcedureContext procedureContext, String tableId, String tagName) throws Catalog.TableNotExistException {
        return this.innerCall(tableId, tagName, null, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String tagName, long snapshotId) throws Catalog.TableNotExistException {
        return this.innerCall(tableId, tagName, snapshotId, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String tagName, long snapshotId, String timeRetained) throws Catalog.TableNotExistException {
        return this.innerCall(tableId, tagName, snapshotId, timeRetained);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String tagName, String timeRetained) throws Catalog.TableNotExistException {
        return this.innerCall(tableId, tagName, null, timeRetained);
    }

    private String[] innerCall(String tableId, String tagName, @Nullable Long snapshotId, @Nullable String timeRetained) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        this.createOrReplaceTag(table, tagName, snapshotId, CreateOrReplaceTagBaseProcedure.toDuration(timeRetained));
        return new String[]{"Success"};
    }

    abstract void createOrReplaceTag(Table var1, String var2, Long var3, Duration var4);

    @Nullable
    private static Duration toDuration(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return TimeUtils.parseDuration(s);
    }
}

