/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.FileStore;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ProcedureUtils;

public class ExpirePartitionsProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "expire_partitions";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy) throws Catalog.TableNotExistException {
        return this.call(procedureContext, tableId, expirationTime, timestampFormatter, timestampPattern, expireStrategy, null, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy, Integer maxExpires, String options) throws Catalog.TableNotExistException {
        String[] stringArray;
        Map<String, String> dynamicOptions = ProcedureUtils.fillInPartitionOptions(expireStrategy, timestampFormatter, timestampPattern, expirationTime, maxExpires, options);
        Table table = this.table(tableId).copy(dynamicOptions);
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        FileStore<?> fileStore = fileStoreTable.store();
        PartitionExpire partitionExpire = fileStore.newPartitionExpire("", fileStoreTable);
        Preconditions.checkNotNull(partitionExpire, "Both the partition expiration time and partition field can not be null.");
        List<Map<String, String>> expired = partitionExpire.expire(Long.MAX_VALUE);
        if (expired == null || expired.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "No expired partitions.";
        } else {
            stringArray = (String[])expired.stream().map(x -> {
                String r = x.toString();
                return r.substring(1, r.length() - 1);
            }).toArray(String[]::new);
        }
        return stringArray;
    }
}

