/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.procedures.Procedure;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.flink.procedure.ProcedureBase;

public class ProcedureUtil {
    private ProcedureUtil() {
    }

    public static List<String> listProcedures() {
        return Collections.unmodifiableList(FactoryUtil.discoverIdentifiers(ProcedureBase.class.getClassLoader(), ProcedureBase.class));
    }

    public static Optional<Procedure> getProcedure(Catalog catalog, ObjectPath procedurePath) {
        if (!"sys".equals(procedurePath.getDatabaseName())) {
            return Optional.empty();
        }
        try {
            ProcedureBase procedure = FactoryUtil.discoverFactory(ProcedureBase.class.getClassLoader(), ProcedureBase.class, procedurePath.getObjectName()).withCatalog(catalog);
            return Optional.of(procedure);
        }
        catch (FactoryException e) {
            return Optional.empty();
        }
    }
}

