/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MigrateIcebergTableAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class MigrateIcebergTableActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "migrate_iceberg_table";
    private static final String OPTIONS = "options";
    private static final String PARALLELISM = "parallelism";
    private static final String ICEBERG_OPTIONS = "iceberg_options";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String sourceTable = params.get("table");
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        String tableConf = params.get(OPTIONS);
        Integer parallelism = params.get(PARALLELISM) == null ? null : Integer.valueOf(Integer.parseInt(params.get(PARALLELISM)));
        String icebergOptions = params.get(ICEBERG_OPTIONS);
        MigrateIcebergTableAction migrateIcebergTableAction = new MigrateIcebergTableAction(sourceTable, catalogConfig, icebergOptions, tableConf, parallelism);
        return Optional.of(migrateIcebergTableAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"migrate_iceberg_table\" runs a migrating job from iceberg to paimon.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  migrate_iceberg_table \\\n--table <database.table_name> \\\n--iceberg_options <key>=<value>[,<key>=<value>,...] \\\n[--catalog_conf <key>=<value] \\\n[--options <key>=<value>,<key>=<value>,...]");
    }
}

