/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup.partitioner;

import java.util.HashSet;
import java.util.Set;
import org.apache.paimon.flink.lookup.partitioner.ShuffleStrategy;
import org.apache.paimon.utils.Preconditions;

public class BucketShuffleStrategy
implements ShuffleStrategy {
    private final int numBuckets;

    public BucketShuffleStrategy(int numBuckets) {
        Preconditions.checkState(numBuckets > 0, "Number of buckets should be positive.");
        this.numBuckets = numBuckets;
    }

    @Override
    public int getTargetSubtaskId(int bucketId, int joinKeyHash, int numSubtasks) {
        if (this.numBuckets >= numSubtasks) {
            return bucketId % numSubtasks;
        }
        int bucketNumMultipleRange = numSubtasks / this.numBuckets;
        int adjustedBucketNumMultipleRange = bucketId + bucketNumMultipleRange * this.numBuckets >= numSubtasks ? bucketNumMultipleRange : bucketNumMultipleRange + 1;
        return joinKeyHash % adjustedBucketNumMultipleRange * this.numBuckets + bucketId;
    }

    @Override
    public Set<Integer> getRequiredCacheBucketIds(int subtaskId, int numSubtasks) {
        HashSet<Integer> requiredCacheBucketIds = new HashSet<Integer>();
        if (this.numBuckets >= numSubtasks) {
            for (int bucketId = 0; bucketId < this.numBuckets; ++bucketId) {
                if (bucketId % numSubtasks != subtaskId) continue;
                requiredCacheBucketIds.add(bucketId);
            }
        } else {
            for (int bucketId = 0; bucketId < this.numBuckets; ++bucketId) {
                if (bucketId != subtaskId % this.numBuckets) continue;
                requiredCacheBucketIds.add(bucketId);
            }
        }
        return requiredCacheBucketIds;
    }
}

