/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.Table;

public class CreateBranchProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "create_branch";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String branchName, String tagName) throws Catalog.TableNotExistException {
        return this.innerCall(tableId, branchName, tagName);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String branchName) throws Catalog.TableNotExistException {
        return this.innerCall(tableId, branchName, null);
    }

    private String[] innerCall(String tableId, String branchName, String tagName) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        if (!StringUtils.isBlank((CharSequence)tagName)) {
            table.createBranch(branchName, tagName);
        } else {
            table.createBranch(branchName);
        }
        return new String[]{"Success"};
    }
}

