/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import java.util.TimeZone;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireChangelogImpl;
import org.apache.paimon.utils.DateTimeUtils;

public class ExpireChangelogsProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "expire_changelogs";
    }

    public String[] call(ProcedureContext procedureContext, String tableId, int retainMax, int retainMin, String olderThan) throws Catalog.TableNotExistException {
        return this.call(procedureContext, tableId, retainMax, retainMin, olderThan, Integer.MAX_VALUE);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, int retainMax, int retainMin, String olderThan, int maxDeletes) throws Catalog.TableNotExistException {
        ExpireChangelogImpl expireChangelogs = (ExpireChangelogImpl)this.table(tableId).newExpireChangelog();
        ExpireConfig.Builder builder = ExpireConfig.builder();
        builder.changelogRetainMax(retainMax);
        builder.changelogRetainMin(retainMin);
        builder.changelogTimeRetain(Duration.ofMillis(System.currentTimeMillis() - DateTimeUtils.parseTimestampData(olderThan, 3, TimeZone.getDefault()).getMillisecond()));
        builder.changelogMaxDeletes(maxDeletes);
        return new String[]{expireChangelogs.config(builder.build()).expire() + ""};
    }

    public String[] call(ProcedureContext procedureContext, String tableId, boolean deleteAll) throws Catalog.TableNotExistException {
        ExpireChangelogImpl expireChangelogs = (ExpireChangelogImpl)this.table(tableId).newExpireChangelog();
        if (deleteAll) {
            expireChangelogs.expireAll();
            return new String[]{"Delete all separated changelogs success."};
        }
        return new String[]{"deleteAll is false, do nothing."};
    }
}

