/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.LocalDateTime;
import java.util.List;
import java.util.TimeZone;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.tag.TagTimeExpire;
import org.apache.paimon.utils.DateTimeUtils;

public class ExpireTagsProcedure
extends ProcedureBase {
    private static final String IDENTIFIER = "expire_tags";

    public String[] call(ProcedureContext procedureContext, String tableId) throws Catalog.TableNotExistException {
        return this.call(procedureContext, tableId, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThanStr) throws Catalog.TableNotExistException {
        String[] stringArray;
        List<String> expired;
        FileStoreTable fileStoreTable = (FileStoreTable)this.table(tableId);
        TagTimeExpire tagTimeExpire = fileStoreTable.store().newTagCreationManager(fileStoreTable).getTagTimeExpire();
        if (olderThanStr != null) {
            LocalDateTime olderThanTime = DateTimeUtils.parseTimestampData(olderThanStr, 3, TimeZone.getDefault()).toLocalDateTime();
            tagTimeExpire.withOlderThanTime(olderThanTime);
        }
        if ((expired = tagTimeExpire.expire()).isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "No expired tags.";
        } else {
            stringArray = expired.toArray(new String[0]);
        }
        return stringArray;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

