/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.io.IOException;
import java.util.List;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.sink.listener.PartitionMarkDoneListener;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.Preconditions;

public class MarkPartitionDoneProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "mark_partition_done";

    public String[] call(ProcedureContext procedureContext, String tableId, String ... partitionStrings) throws Catalog.TableNotExistException, IOException {
        Preconditions.checkArgument(partitionStrings.length > 0, "mark_partition_done procedure must specify partitions.");
        Identifier identifier = Identifier.fromString(tableId);
        Table table = this.catalog.getTable(identifier);
        Preconditions.checkArgument(table instanceof FileStoreTable, "Only FileStoreTable supports mark_partition_done procedure. The table type is '%s'.", table.getClass().getName());
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        CoreOptions coreOptions = fileStoreTable.coreOptions();
        List<PartitionMarkDoneAction> actions = PartitionMarkDoneAction.createActions(this.getClass().getClassLoader(), fileStoreTable, coreOptions);
        List<String> partitionPaths = PartitionPathUtils.generatePartitionPaths(ParameterUtils.getPartitions(partitionStrings), fileStoreTable.store().partitionType());
        PartitionMarkDoneListener.markDone(partitionPaths, actions);
        IOUtils.closeAllQuietly(actions);
        return new String[]{"Success"};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

