/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateTableProcedure
extends ProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateTableProcedure.class);
    private static final String PAIMON_SUFFIX = "_paimon_";

    @Override
    public String identifier() {
        return "migrate_table";
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath) throws Exception {
        return this.call(procedureContext, connector, sourceTablePath, "");
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String properties) throws Exception {
        return this.call(procedureContext, connector, sourceTablePath, properties, Runtime.getRuntime().availableProcessors());
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String properties, Integer parallelism) throws Exception {
        String targetTablePath = sourceTablePath + PAIMON_SUFFIX;
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetTablePath);
        Migrator migrator = TableMigrationUtils.getImporter(connector, this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), parallelism, ParameterUtils.parseCommaSeparatedKeyValues(properties));
        LOG.info("create migrator success.");
        migrator.executeMigrate();
        migrator.renameTable(false);
        return new String[]{"Success"};
    }
}

