/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Locale;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.orphan.FlinkOrphanFilesClean;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.CleanOrphanFilesResult;
import org.apache.paimon.operation.LocalOrphanFilesClean;
import org.apache.paimon.operation.OrphanFilesClean;

public class RemoveOrphanFilesProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "remove_orphan_files";

    public String[] call(ProcedureContext procedureContext, String tableId) throws Exception {
        return this.call(procedureContext, tableId, "");
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan) throws Exception {
        return this.call(procedureContext, tableId, olderThan, false);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan, boolean dryRun) throws Exception {
        return this.call(procedureContext, tableId, olderThan, dryRun, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan, boolean dryRun, Integer parallelism) throws Exception {
        return this.call(procedureContext, tableId, olderThan, dryRun, parallelism, null);
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan, boolean dryRun, Integer parallelism, String mode) throws Exception {
        Identifier identifier = Identifier.fromString(tableId);
        String databaseName = identifier.getDatabaseName();
        String tableName = identifier.getObjectName();
        if (mode == null) {
            mode = "DISTRIBUTED";
        }
        try {
            CleanOrphanFilesResult cleanOrphanFilesResult;
            switch (mode.toUpperCase(Locale.ROOT)) {
                case "DISTRIBUTED": {
                    cleanOrphanFilesResult = FlinkOrphanFilesClean.executeDatabaseOrphanFiles(procedureContext.getExecutionEnvironment(), this.catalog, OrphanFilesClean.olderThanMillis(olderThan), dryRun, parallelism, databaseName, tableName);
                    break;
                }
                case "LOCAL": {
                    cleanOrphanFilesResult = LocalOrphanFilesClean.executeDatabaseOrphanFiles(this.catalog, databaseName, tableName, OrphanFilesClean.olderThanMillis(olderThan), parallelism, dryRun);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode + ". Only 'DISTRIBUTED' and 'LOCAL' are supported.");
                }
            }
            return new String[]{String.valueOf(cleanOrphanFilesResult.getDeletedFileCount()), String.valueOf(cleanOrphanFilesResult.getDeletedFileTotalLenInBytes())};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

