/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;

public class RollbackToTimestampProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "rollback_to_timestamp";

    public String[] call(ProcedureContext procedureContext, String tableId, long timestamp) throws Catalog.TableNotExistException {
        Preconditions.checkNotNull(tableId, "table can not be empty");
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        Snapshot snapshot = fileStoreTable.snapshotManager().earlierOrEqualTimeMills(timestamp);
        Preconditions.checkNotNull(snapshot, String.format("count not find snapshot earlier than %s", timestamp));
        long snapshotId = snapshot.id();
        fileStoreTable.rollbackTo(snapshotId);
        return new String[]{String.format("Success roll back to snapshot: %s .", snapshotId)};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

