/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.io.IOException;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryMap;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.NestedRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.GenericVariant;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MurmurHashUtils;

public class MemorySegmentUtils {
    private static final int ADDRESS_BITS_PER_WORD = 3;
    public static final int BIT_BYTE_INDEX_MASK = 7;
    private static final int MAX_BYTES_LENGTH = 65536;
    private static final int MAX_CHARS_LENGTH = 32768;
    private static final ThreadLocal<byte[]> BYTES_LOCAL = new ThreadLocal();
    private static final ThreadLocal<char[]> CHARS_LOCAL = new ThreadLocal();

    public static byte[] allocateReuseBytes(int length) {
        byte[] bytes = BYTES_LOCAL.get();
        if (bytes == null) {
            if (length <= 65536) {
                bytes = new byte[65536];
                BYTES_LOCAL.set(bytes);
            } else {
                bytes = new byte[length];
            }
        } else if (bytes.length < length) {
            bytes = new byte[length];
        }
        return bytes;
    }

    public static char[] allocateReuseChars(int length) {
        char[] chars = CHARS_LOCAL.get();
        if (chars == null) {
            if (length <= 32768) {
                chars = new char[32768];
                CHARS_LOCAL.set(chars);
            } else {
                chars = new char[length];
            }
        } else if (chars.length < length) {
            chars = new char[length];
        }
        return chars;
    }

    public static void copyToView(MemorySegment[] segments, int offset, int sizeInBytes, DataOutputView target) throws IOException {
        for (MemorySegment sourceSegment : segments) {
            int curSegRemain = sourceSegment.size() - offset;
            if (curSegRemain > 0) {
                int copySize = Math.min(curSegRemain, sizeInBytes);
                byte[] bytes = MemorySegmentUtils.allocateReuseBytes(copySize);
                sourceSegment.get(offset, bytes, 0, copySize);
                target.write(bytes, 0, copySize);
                sizeInBytes -= copySize;
                offset = 0;
            } else {
                offset -= sourceSegment.size();
            }
            if (sizeInBytes != 0) continue;
            return;
        }
        if (sizeInBytes != 0) {
            throw new RuntimeException("No copy finished, this should be a bug, The remaining length is: " + sizeInBytes);
        }
    }

    public static void copyFromBytes(MemorySegment[] segments, int offset, byte[] bytes, int bytesOffset, int numBytes) {
        if (segments.length == 1) {
            segments[0].put(offset, bytes, bytesOffset, numBytes);
        } else {
            MemorySegmentUtils.copyMultiSegmentsFromBytes(segments, offset, bytes, bytesOffset, numBytes);
        }
    }

    private static void copyMultiSegmentsFromBytes(MemorySegment[] segments, int offset, byte[] bytes, int bytesOffset, int numBytes) {
        int remainSize = numBytes;
        for (MemorySegment segment : segments) {
            int remain = segment.size() - offset;
            if (remain > 0) {
                int nCopy = Math.min(remain, remainSize);
                segment.put(offset, bytes, numBytes - remainSize + bytesOffset, nCopy);
                offset = 0;
                if ((remainSize -= nCopy) != 0) continue;
                return;
            }
            offset = -remain;
        }
    }

    public static byte[] getBytes(MemorySegment[] segments, int baseOffset, int sizeInBytes) {
        if (segments.length == 1) {
            byte[] heapMemory = segments[0].getHeapMemory();
            if (baseOffset == 0 && heapMemory != null && heapMemory.length == sizeInBytes) {
                return heapMemory;
            }
            byte[] bytes = new byte[sizeInBytes];
            segments[0].get(baseOffset, bytes, 0, sizeInBytes);
            return bytes;
        }
        byte[] bytes = new byte[sizeInBytes];
        MemorySegmentUtils.copyMultiSegmentsToBytes(segments, baseOffset, bytes, 0, sizeInBytes);
        return bytes;
    }

    public static boolean equals(MemorySegment[] segments1, int offset1, MemorySegment[] segments2, int offset2, int len) {
        if (MemorySegmentUtils.inFirstSegment(segments1, offset1, len) && MemorySegmentUtils.inFirstSegment(segments2, offset2, len)) {
            return segments1[0].equalTo(segments2[0], offset1, offset2, len);
        }
        return MemorySegmentUtils.equalsMultiSegments(segments1, offset1, segments2, offset2, len);
    }

    @VisibleForTesting
    static boolean equalsMultiSegments(MemorySegment[] segments1, int offset1, MemorySegment[] segments2, int offset2, int len) {
        if (len == 0) {
            return true;
        }
        int segSize1 = segments1[0].size();
        int segSize2 = segments2[0].size();
        int segIndex1 = offset1 / segSize1;
        int segIndex2 = offset2 / segSize2;
        int segOffset1 = offset1 - segSize1 * segIndex1;
        int segOffset2 = offset2 - segSize2 * segIndex2;
        while (len > 0) {
            int equalLen = Math.min(Math.min(len, segSize1 - segOffset1), segSize2 - segOffset2);
            if (!segments1[segIndex1].equalTo(segments2[segIndex2], segOffset1, segOffset2, equalLen)) {
                return false;
            }
            len -= equalLen;
            if ((segOffset1 += equalLen) == segSize1) {
                segOffset1 = 0;
                ++segIndex1;
            }
            if ((segOffset2 += equalLen) != segSize2) continue;
            segOffset2 = 0;
            ++segIndex2;
        }
        return true;
    }

    public static byte[] copyToBytes(MemorySegment[] segments, int offset, int numBytes) {
        return MemorySegmentUtils.copyToBytes(segments, offset, new byte[numBytes], 0, numBytes);
    }

    public static byte[] copyToBytes(MemorySegment[] segments, int offset, byte[] bytes, int bytesOffset, int numBytes) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, numBytes)) {
            segments[0].get(offset, bytes, bytesOffset, numBytes);
        } else {
            MemorySegmentUtils.copyMultiSegmentsToBytes(segments, offset, bytes, bytesOffset, numBytes);
        }
        return bytes;
    }

    public static void copyMultiSegmentsToBytes(MemorySegment[] segments, int offset, byte[] bytes, int bytesOffset, int numBytes) {
        int remainSize = numBytes;
        for (MemorySegment segment : segments) {
            int remain = segment.size() - offset;
            if (remain > 0) {
                int nCopy = Math.min(remain, remainSize);
                segment.get(offset, bytes, numBytes - remainSize + bytesOffset, nCopy);
                offset = 0;
                if ((remainSize -= nCopy) != 0) continue;
                return;
            }
            offset = -remain;
        }
    }

    public static void copyToUnsafe(MemorySegment[] segments, int offset, Object target, int pointer, int numBytes) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, numBytes)) {
            segments[0].copyToUnsafe(offset, target, pointer, numBytes);
        } else {
            MemorySegmentUtils.copyMultiSegmentsToUnsafe(segments, offset, target, pointer, numBytes);
        }
    }

    private static void copyMultiSegmentsToUnsafe(MemorySegment[] segments, int offset, Object target, int pointer, int numBytes) {
        int remainSize = numBytes;
        for (MemorySegment segment : segments) {
            int remain = segment.size() - offset;
            if (remain > 0) {
                int nCopy = Math.min(remain, remainSize);
                segment.copyToUnsafe(offset, target, numBytes - remainSize + pointer, nCopy);
                offset = 0;
                if ((remainSize -= nCopy) != 0) continue;
                return;
            }
            offset = -remain;
        }
    }

    public static int hashByWords(MemorySegment[] segments, int offset, int numBytes) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, numBytes)) {
            return MurmurHashUtils.hashBytesByWords(segments[0], offset, numBytes);
        }
        return MemorySegmentUtils.hashMultiSegByWords(segments, offset, numBytes);
    }

    private static int hashMultiSegByWords(MemorySegment[] segments, int offset, int numBytes) {
        byte[] bytes = MemorySegmentUtils.allocateReuseBytes(numBytes);
        MemorySegmentUtils.copyMultiSegmentsToBytes(segments, offset, bytes, 0, numBytes);
        return MurmurHashUtils.hashUnsafeBytesByWords(bytes, MemorySegment.BYTE_ARRAY_BASE_OFFSET, numBytes);
    }

    public static int hash(MemorySegment[] segments, int offset, int numBytes) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, numBytes)) {
            return MurmurHashUtils.hashBytes(segments[0], offset, numBytes);
        }
        return MemorySegmentUtils.hashMultiSeg(segments, offset, numBytes);
    }

    private static int hashMultiSeg(MemorySegment[] segments, int offset, int numBytes) {
        byte[] bytes = MemorySegmentUtils.allocateReuseBytes(numBytes);
        MemorySegmentUtils.copyMultiSegmentsToBytes(segments, offset, bytes, 0, numBytes);
        return MurmurHashUtils.hashUnsafeBytes(bytes, MemorySegment.BYTE_ARRAY_BASE_OFFSET, numBytes);
    }

    private static boolean inFirstSegment(MemorySegment[] segments, int offset, int numBytes) {
        return numBytes + offset <= segments[0].size();
    }

    public static int find(MemorySegment[] segments1, int offset1, int numBytes1, MemorySegment[] segments2, int offset2, int numBytes2) {
        if (numBytes2 == 0) {
            return offset1;
        }
        if (MemorySegmentUtils.inFirstSegment(segments1, offset1, numBytes1) && MemorySegmentUtils.inFirstSegment(segments2, offset2, numBytes2)) {
            byte first = segments2[0].get(offset2);
            int end = numBytes1 - numBytes2 + offset1;
            for (int i = offset1; i <= end; ++i) {
                if (segments1[0].get(i) != first || !segments1[0].equalTo(segments2[0], i, offset2, numBytes2)) continue;
                return i;
            }
            return -1;
        }
        return MemorySegmentUtils.findInMultiSegments(segments1, offset1, numBytes1, segments2, offset2, numBytes2);
    }

    private static int findInMultiSegments(MemorySegment[] segments1, int offset1, int numBytes1, MemorySegment[] segments2, int offset2, int numBytes2) {
        int end = numBytes1 - numBytes2 + offset1;
        for (int i = offset1; i <= end; ++i) {
            if (!MemorySegmentUtils.equalsMultiSegments(segments1, i, segments2, offset2, numBytes2)) continue;
            return i;
        }
        return -1;
    }

    public static int byteIndex(int bitIndex) {
        return bitIndex >>> 3;
    }

    public static void bitUnSet(MemorySegment segment, int baseOffset, int index) {
        int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
        byte current = segment.get(offset);
        current = (byte)(current & ~(1 << (index & 7)));
        segment.put(offset, current);
    }

    public static void bitSet(MemorySegment segment, int baseOffset, int index) {
        int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
        byte current = segment.get(offset);
        current = (byte)(current | 1 << (index & 7));
        segment.put(offset, current);
    }

    public static boolean bitGet(MemorySegment segment, int baseOffset, int index) {
        int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
        byte current = segment.get(offset);
        return (current & 1 << (index & 7)) != 0;
    }

    public static void bitUnSet(MemorySegment[] segments, int baseOffset, int index) {
        if (segments.length == 1) {
            MemorySegment segment = segments[0];
            int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
            byte current = segment.get(offset);
            current = (byte)(current & ~(1 << (index & 7)));
            segment.put(offset, current);
        } else {
            MemorySegmentUtils.bitUnSetMultiSegments(segments, baseOffset, index);
        }
    }

    private static void bitUnSetMultiSegments(MemorySegment[] segments, int baseOffset, int index) {
        int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        MemorySegment segment = segments[segIndex];
        byte current = segment.get(segOffset);
        current = (byte)(current & ~(1 << (index & 7)));
        segment.put(segOffset, current);
    }

    public static void bitSet(MemorySegment[] segments, int baseOffset, int index) {
        if (segments.length == 1) {
            int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
            MemorySegment segment = segments[0];
            byte current = segment.get(offset);
            current = (byte)(current | 1 << (index & 7));
            segment.put(offset, current);
        } else {
            MemorySegmentUtils.bitSetMultiSegments(segments, baseOffset, index);
        }
    }

    private static void bitSetMultiSegments(MemorySegment[] segments, int baseOffset, int index) {
        int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        MemorySegment segment = segments[segIndex];
        byte current = segment.get(segOffset);
        current = (byte)(current | 1 << (index & 7));
        segment.put(segOffset, current);
    }

    public static boolean bitGet(MemorySegment[] segments, int baseOffset, int index) {
        int offset = baseOffset + MemorySegmentUtils.byteIndex(index);
        byte current = MemorySegmentUtils.getByte(segments, offset);
        return (current & 1 << (index & 7)) != 0;
    }

    public static boolean getBoolean(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 1)) {
            return segments[0].getBoolean(offset);
        }
        return MemorySegmentUtils.getBooleanMultiSegments(segments, offset);
    }

    private static boolean getBooleanMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        return segments[segIndex].getBoolean(segOffset);
    }

    public static void setBoolean(MemorySegment[] segments, int offset, boolean value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 1)) {
            segments[0].putBoolean(offset, value);
        } else {
            MemorySegmentUtils.setBooleanMultiSegments(segments, offset, value);
        }
    }

    private static void setBooleanMultiSegments(MemorySegment[] segments, int offset, boolean value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        segments[segIndex].putBoolean(segOffset, value);
    }

    public static byte getByte(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 1)) {
            return segments[0].get(offset);
        }
        return MemorySegmentUtils.getByteMultiSegments(segments, offset);
    }

    private static byte getByteMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        return segments[segIndex].get(segOffset);
    }

    public static void setByte(MemorySegment[] segments, int offset, byte value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 1)) {
            segments[0].put(offset, value);
        } else {
            MemorySegmentUtils.setByteMultiSegments(segments, offset, value);
        }
    }

    private static void setByteMultiSegments(MemorySegment[] segments, int offset, byte value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        segments[segIndex].put(segOffset, value);
    }

    public static int getInt(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 4)) {
            return segments[0].getInt(offset);
        }
        return MemorySegmentUtils.getIntMultiSegments(segments, offset);
    }

    private static int getIntMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            return segments[segIndex].getInt(segOffset);
        }
        return MemorySegmentUtils.getIntSlowly(segments, segSize, segIndex, segOffset);
    }

    private static int getIntSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset) {
        MemorySegment segment = segments[segNum];
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            int unsignedByte = segment.get(segOffset) & 0xFF;
            ret = MemorySegment.LITTLE_ENDIAN ? (ret |= unsignedByte << i * 8) : (ret |= unsignedByte << (3 - i) * 8);
            ++segOffset;
        }
        return ret;
    }

    public static void setInt(MemorySegment[] segments, int offset, int value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 4)) {
            segments[0].putInt(offset, value);
        } else {
            MemorySegmentUtils.setIntMultiSegments(segments, offset, value);
        }
    }

    private static void setIntMultiSegments(MemorySegment[] segments, int offset, int value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            segments[segIndex].putInt(segOffset, value);
        } else {
            MemorySegmentUtils.setIntSlowly(segments, segSize, segIndex, segOffset, value);
        }
    }

    private static void setIntSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset, int value) {
        MemorySegment segment = segments[segNum];
        for (int i = 0; i < 4; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            int unsignedByte = MemorySegment.LITTLE_ENDIAN ? value >> i * 8 : value >> (3 - i) * 8;
            segment.put(segOffset, (byte)unsignedByte);
            ++segOffset;
        }
    }

    public static long getLong(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 8)) {
            return segments[0].getLong(offset);
        }
        return MemorySegmentUtils.getLongMultiSegments(segments, offset);
    }

    private static long getLongMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            return segments[segIndex].getLong(segOffset);
        }
        return MemorySegmentUtils.getLongSlowly(segments, segSize, segIndex, segOffset);
    }

    private static long getLongSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset) {
        MemorySegment segment = segments[segNum];
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            long unsignedByte = segment.get(segOffset) & 0xFF;
            ret = MemorySegment.LITTLE_ENDIAN ? (ret |= unsignedByte << i * 8) : (ret |= unsignedByte << (7 - i) * 8);
            ++segOffset;
        }
        return ret;
    }

    public static void setLong(MemorySegment[] segments, int offset, long value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 8)) {
            segments[0].putLong(offset, value);
        } else {
            MemorySegmentUtils.setLongMultiSegments(segments, offset, value);
        }
    }

    private static void setLongMultiSegments(MemorySegment[] segments, int offset, long value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            segments[segIndex].putLong(segOffset, value);
        } else {
            MemorySegmentUtils.setLongSlowly(segments, segSize, segIndex, segOffset, value);
        }
    }

    private static void setLongSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset, long value) {
        MemorySegment segment = segments[segNum];
        for (int i = 0; i < 8; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            long unsignedByte = MemorySegment.LITTLE_ENDIAN ? value >> i * 8 : value >> (7 - i) * 8;
            segment.put(segOffset, (byte)unsignedByte);
            ++segOffset;
        }
    }

    public static short getShort(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 2)) {
            return segments[0].getShort(offset);
        }
        return MemorySegmentUtils.getShortMultiSegments(segments, offset);
    }

    private static short getShortMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 1) {
            return segments[segIndex].getShort(segOffset);
        }
        return (short)MemorySegmentUtils.getTwoByteSlowly(segments, segSize, segIndex, segOffset);
    }

    public static void setShort(MemorySegment[] segments, int offset, short value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 2)) {
            segments[0].putShort(offset, value);
        } else {
            MemorySegmentUtils.setShortMultiSegments(segments, offset, value);
        }
    }

    private static void setShortMultiSegments(MemorySegment[] segments, int offset, short value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 1) {
            segments[segIndex].putShort(segOffset, value);
        } else {
            MemorySegmentUtils.setTwoByteSlowly(segments, segSize, segIndex, segOffset, value, value >> 8);
        }
    }

    public static float getFloat(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 4)) {
            return segments[0].getFloat(offset);
        }
        return MemorySegmentUtils.getFloatMultiSegments(segments, offset);
    }

    private static float getFloatMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            return segments[segIndex].getFloat(segOffset);
        }
        return Float.intBitsToFloat(MemorySegmentUtils.getIntSlowly(segments, segSize, segIndex, segOffset));
    }

    public static void setFloat(MemorySegment[] segments, int offset, float value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 4)) {
            segments[0].putFloat(offset, value);
        } else {
            MemorySegmentUtils.setFloatMultiSegments(segments, offset, value);
        }
    }

    private static void setFloatMultiSegments(MemorySegment[] segments, int offset, float value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            segments[segIndex].putFloat(segOffset, value);
        } else {
            MemorySegmentUtils.setIntSlowly(segments, segSize, segIndex, segOffset, Float.floatToRawIntBits(value));
        }
    }

    public static double getDouble(MemorySegment[] segments, int offset) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 8)) {
            return segments[0].getDouble(offset);
        }
        return MemorySegmentUtils.getDoubleMultiSegments(segments, offset);
    }

    private static double getDoubleMultiSegments(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            return segments[segIndex].getDouble(segOffset);
        }
        return Double.longBitsToDouble(MemorySegmentUtils.getLongSlowly(segments, segSize, segIndex, segOffset));
    }

    public static void setDouble(MemorySegment[] segments, int offset, double value) {
        if (MemorySegmentUtils.inFirstSegment(segments, offset, 8)) {
            segments[0].putDouble(offset, value);
        } else {
            MemorySegmentUtils.setDoubleMultiSegments(segments, offset, value);
        }
    }

    private static void setDoubleMultiSegments(MemorySegment[] segments, int offset, double value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            segments[segIndex].putDouble(segOffset, value);
        } else {
            MemorySegmentUtils.setLongSlowly(segments, segSize, segIndex, segOffset, Double.doubleToRawLongBits(value));
        }
    }

    private static int getTwoByteSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset) {
        MemorySegment segment = segments[segNum];
        int ret = 0;
        for (int i = 0; i < 2; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            int unsignedByte = segment.get(segOffset) & 0xFF;
            ret = MemorySegment.LITTLE_ENDIAN ? (ret |= unsignedByte << i * 8) : (ret |= unsignedByte << (1 - i) * 8);
            ++segOffset;
        }
        return ret;
    }

    private static void setTwoByteSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset, int b1, int b2) {
        MemorySegment segment = segments[segNum];
        segment.put(segOffset, (byte)(MemorySegment.LITTLE_ENDIAN ? b1 : b2));
        if (++segOffset == segSize) {
            segment = segments[++segNum];
            segOffset = 0;
        }
        segment.put(segOffset, (byte)(MemorySegment.LITTLE_ENDIAN ? b2 : b1));
    }

    public static Decimal readDecimal(MemorySegment[] segments, int baseOffset, long offsetAndSize, int precision, int scale) {
        int size = (int)offsetAndSize;
        int subOffset = (int)(offsetAndSize >> 32);
        byte[] bytes = new byte[size];
        MemorySegmentUtils.copyToBytes(segments, baseOffset + subOffset, bytes, 0, size);
        return Decimal.fromUnscaledBytes(bytes, precision, scale);
    }

    public static Timestamp readTimestampData(MemorySegment[] segments, int baseOffset, long offsetAndNanos) {
        int nanoOfMillisecond = (int)offsetAndNanos;
        int subOffset = (int)(offsetAndNanos >> 32);
        long millisecond = MemorySegmentUtils.getLong(segments, baseOffset + subOffset);
        return Timestamp.fromEpochMillis(millisecond, nanoOfMillisecond);
    }

    public static byte[] readBinary(MemorySegment[] segments, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            return MemorySegmentUtils.copyToBytes(segments, baseOffset + subOffset, len);
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        if (MemorySegment.LITTLE_ENDIAN) {
            return MemorySegmentUtils.copyToBytes(segments, fieldOffset, len);
        }
        return MemorySegmentUtils.copyToBytes(segments, fieldOffset + 1, len);
    }

    public static BinaryString readBinaryString(MemorySegment[] segments, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            return BinaryString.fromAddress(segments, baseOffset + subOffset, len);
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        if (MemorySegment.LITTLE_ENDIAN) {
            return BinaryString.fromAddress(segments, fieldOffset, len);
        }
        return BinaryString.fromAddress(segments, fieldOffset + 1, len);
    }

    public static Variant readVariant(MemorySegment[] segments, int baseOffset, long offsetAndLen) {
        int offset = baseOffset + (int)(offsetAndLen >> 32);
        int totalSize = (int)offsetAndLen;
        int valueSize = MemorySegmentUtils.getInt(segments, offset);
        int metadataSize = totalSize - 4 - valueSize;
        byte[] value = MemorySegmentUtils.copyToBytes(segments, offset + 4, valueSize);
        byte[] metadata = MemorySegmentUtils.copyToBytes(segments, offset + 4 + valueSize, metadataSize);
        return new GenericVariant(value, metadata);
    }

    public static InternalMap readMapData(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        BinaryMap map = new BinaryMap();
        map.pointTo(segments, offset + baseOffset, size);
        return map;
    }

    public static InternalArray readArrayData(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        BinaryArray array = new BinaryArray();
        array.pointTo(segments, offset + baseOffset, size);
        return array;
    }

    public static InternalRow readRowData(MemorySegment[] segments, int numFields, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        NestedRow row = new NestedRow(numFields);
        row.pointTo(segments, offset + baseOffset, size);
        return row;
    }
}

